<?php

class Formulario {
    /* @var $db DbMySQL */
    /* @var $RID RandId */

    private $db;
    private $RID;
    private $BaseDeDatos;
    private $Tabla;
    private $ClavePrimaria;
    private $AutoIncremental;

    public function __construct() {
        $this->db = $GLOBALS['db'];
        $this->RID = $GLOBALS['RID'];
    }

    function Ejecutar($Accion) {
        switch ($Accion) {
            case "crud-listar-campos":
                $this->ListarCampos();
                break;

            case "crud-generar":
                $this->Generar();
                break;
        }
    }

    function ListarCampos() {
        $db = $this->db;

//        $sql = "SELECT 
//                    COLUMN_NAME AS Field,
//                    COLUMN_TYPE AS Type,
//                    IS_NULLABLE AS `Null`,
//                    COLUMN_KEY AS `Key`,
//                    EXTRA AS `Extra`
//                FROM
//                    information_schema.COLUMNS
//                WHERE
//                    TABLE_SCHEMA = 'fac'
//                        AND TABLE_NAME = 'matricula'";
//        

        $datos = explode(".", $this->RID->GetValue($_GET['tabla']));

        $base_datos = $datos[0];
        $tabla = $datos[1];

        $sql = "SELECT 
                    COLUMN_NAME AS campo,
                    COLUMN_TYPE AS tipo,
                    EXTRA AS extra,
                    IS_NULLABLE as nulo, 
                    COLUMN_KEY as clave
                FROM
                    information_schema.COLUMNS
                WHERE
                    TABLE_SCHEMA = '$base_datos'
                        AND TABLE_NAME = '$tabla'";



        $result['total'] = $db->count_rows($sql);
        $offset = $_GET['offset'];
        $limit = $_GET['limit'];
        $rs = $db->select_limit($sql, $limit, $offset);
//  
        $result['rows'] = array();
        $num = $offset + 1;
        $primer_campo = true;
        while ($rw = $db->fetch_assoc($rs)) {
            if ($rw['campo'][0] != "_" && $rw['clave'] !== "PRI") {

                $campo = $this->RID->GetRandId($rw['campo']);
                $char = mb_stripos($rw['tipo'], "char") !== false ? true : false;
                $rw['_NUM_'] = $num++;
//
                $titulo = str_replace("_", " ", $rw['campo']);
                $titulo = mb_strtoupper(substr($titulo, 0, 1)) . mb_strtolower(substr($titulo, 1));
                $rw['titulo'] = "<input type='text' class='inp-titulo' name='titulo[$campo]' value='$titulo' style='width:200px'/>";
//
                $chk = $char ? "checked" : "";
                $rw['incluir_grid'] = "<input type='checkbox' name='incluir_grid[$campo]' $chk value='1' />";

                $value = $char && $primer_campo == false ? "200" : "";
                $rw['grid'] = "<input type='text'  class='inp-grid' name='grid[$campo]' value='$value' style='width:40px'/>";
//
                $rw['filtro'] = "<input type='checkbox' name='filtro[$campo]' value='1' />";
                $rw['formulario'] = "<input type='checkbox' class='chk-formulario' name='formulario[$campo]' checked value='1' />";

                if ($char === true) {
                    $rw['mayuscula'] = "<input type='checkbox' class='chk-mayuscula' name='mayuscula[$campo]' value='1'/>";
                    $primer_campo = false;
                }

                $chk = $rw['nulo'] === "NO" ? "checked" : "";
                $rw['oblitatorio'] = "<input type='checkbox' class='chk-obligatorio'  name='obligatorio[$campo]' $chk value='1' />";
                $rw['modificable'] = "<input type='checkbox' class='chk-modificable'  name='modificable[$campo]' checked value='1' />";

                $result['rows'][] = $rw;
            }
        }
        echo json_encode($result);
    }

    function Generar() {
        ob_start();
        $db = $this->db;

        $Datos = explode(".", $this->RID->GetValue($_POST['tabla']));
        $this->BaseDeDatos = $Datos[0];
        $this->Tabla = $Datos[1];

        $sql = "SELECT 
                    COLUMN_NAME, EXTRA
                FROM
                    information_schema.COLUMNS
                WHERE
                    TABLE_SCHEMA = '{$this->BaseDeDatos}'
                        AND TABLE_NAME = '{$this->Tabla}'
                        AND COLUMN_KEY = 'PRI'";

        if ($InfoClavePrimaria = $db->select_row($sql)) {
            $this->ClavePrimaria = $InfoClavePrimaria['COLUMN_NAME'];
            $this->AutoIncremental = ($InfoClavePrimaria === "auto_increment") ? true : false;
        } else {
            $this->ClavePrimaria = "id";
            $this->AutoIncremental = false;
        }

        $Formulario = file_get_contents(__DIR__ . "/formulario.txt");
        $Acciones = file_get_contents(__DIR__ . "/acciones.txt");

        //$ruta = "modulos/prueba";
        $ruta = $_POST['ruta'];
        @mkdir($ruta, 0777, true);
        @chmod($ruta, 0777);

        $Formulario = str_replace("{TITULO_GRID}", $_POST['titulo_grid'], $Formulario);
        $Formulario = str_replace("{TITULO_FORMULARIO}", $_POST['titulo_formulario'], $Formulario);
        $Formulario = str_replace("{NUM_COLS_TITULO}", $_POST['cols_titulo'], $Formulario);
        $Formulario = str_replace("{NUM_COLS_OBJETOS}", $_POST['cols_objeto'], $Formulario);

        // ----------------------------------
        if (isset($_POST['ancho_formulario']) && $_POST['ancho_formulario'] != "") {
            $ClaseAnchoFormulario = "card-" . $_POST['ancho_formulario'];
        } else {
            $ClaseAnchoFormulario = "";
        }
        $Formulario = str_replace("{CLASE_ANCHO_FORMULARIO}", $ClaseAnchoFormulario, $Formulario);

        // ---------------------------------- 
        if (isset($_POST['tipo_formulario']) && $_POST['tipo_formulario'] == "HORIZONTAL") {
            $ClaseFormulario = 'class="form-horizontal"';
        } else {
            $ClaseFormulario = '';
        }
        $Formulario = str_replace("{CLASE_FORMULARIO}", $ClaseFormulario, $Formulario);

        // ---------------------------------- 
        if (isset($_POST['tipo_formulario']) && $_POST['tipo_formulario'] == "HORIZONTAL") {
            $s = '
                <div class="form-group row mb-0">
                    <div class="col-sm-10 offset-sm-2">
                        <input type="button" class="btn   btn-sm btn-success btn-aceptar" value="Guardar">
                        <input type="button" class="btn   btn-sm  btn-secondary btn-regresar" value="Regresar">
                    </div>
                </div>';
        } else {
            $s = '
                <div class="form-group form-btns-actions-right mb-0">
                    <input type="button" class="btn btn-sm btn-success btn-aceptar" value="Guardar">
                    <input type="button" class="btn btn-sm btn-secondary btn-regresar" value="Regresar">
                </div>
                ';
        }
        $Formulario = str_replace("{BOTONES_DE_ACCION}", $s, $Formulario);



        //
        $NombreClase = "";
        $Partes = explode("_", $this->Tabla);
        foreach ($Partes as $p) {
            $NombreClase .= mb_convert_case($p, MB_CASE_TITLE);
        }
        //
        $Acciones = str_replace('{NOMBRE_CLASE}', $NombreClase, $Acciones);

        //
        $Formulario = str_replace("{OBJETOS_FORMULARIO}", $this->GenerarFormulario(), $Formulario);
        //
        $CodigoAcciones = $this->GenerarAcciones();
        $Acciones = str_replace('{CODIGO_AGREGAR}', $CodigoAcciones['Agregar'], $Acciones);
        $Acciones = str_replace('{CODIGO_MODIFICAR}', $CodigoAcciones['Modificar'], $Acciones);
        $Acciones = str_replace('{CODIGO_ASIGNAR}', $CodigoAcciones['Asignar'], $Acciones);


        $Formulario = str_replace("{CLAVE_PRIMARIA}", $this->ClavePrimaria, $Formulario);
        $Acciones = str_replace("{CLAVE_PRIMARIA}", $this->ClavePrimaria, $Acciones);
        $Acciones = str_replace("{VARIABLE_CLAVE_PRIMARIA}", "$" .
                mb_convert_case($this->ClavePrimaria, MB_CASE_TITLE), $Acciones);

        $Acciones = str_replace("{BASE_DATOS}", $this->BaseDeDatos, $Acciones);
        $Acciones = str_replace("{TABLA}", $this->Tabla, $Acciones);
        $Acciones = str_replace("{VALIDACIONES}", $this->GenerarValidaciones(), $Acciones);


        $Grid = $this->GenerarGrid();
        $Formulario = str_replace("{CAMPOS_GRID}", $Grid['Campos'], $Formulario);
        $Acciones = str_replace("{PHP_FILTROS}", $Grid['PhpFiltros'], $Acciones);
        $Acciones = str_replace("{SQL_FILTROS}", $Grid['SqlFiltros'], $Acciones);
        $Acciones = str_replace("{PHP_EJECUTAR}", $Grid['PhpEjecutar'], $Acciones);
        $Acciones = str_replace("{PHP_ACCIONES}", $Grid['PhpAcciones'], $Acciones);


        $XmlAcciones = $Grid['XmlAcciones'];

        $RutaFormulario = $ruta . "/formulario.php";
        $RutaAcciones = $ruta . "/acciones.php";
        file_put_contents($RutaFormulario, $Formulario);
        file_put_contents($RutaAcciones, $Acciones);
        chmod($RutaFormulario, 0777);
        chmod($RutaAcciones, 0777);


        $Doc = new DOMDocument();
        $Doc->formatOutput = true;
        $MenuId = $_POST['menu'];
        $MenuPadreId = $_POST['padre'];


        $Doc->load('menu.xml');

        $xpath = new DOMXPath($Doc);
        $Menu = $xpath->query("//item[@id='$MenuId']")->item(0);
        if ($Menu !== NULL) {
            $Menu->parentNode->removeChild($Menu);
        }

        $MenuPadre = $xpath->query("//item[@id='$MenuPadreId']")->item(0);

        if ($MenuPadre->getElementsByTagName("menu")->length === 0) {
            $Aux = $Doc->createElement("menu");
            $MenuPadre = $MenuPadre->appendChild($Aux);
        } else {
            $MenuPadre = $MenuPadre->getElementsByTagName("menu")->item(0);
        }


        $Item = $Doc->createElement('item');
        $Item->setAttribute("id", $MenuId);
        $Item->setAttribute("titulo", $_POST['titulo_grid']);
        $Item->setAttribute("visible", "S");
        $Item->setAttribute("tipo-acceso", $_POST['tipo_acceso']);
        $Item->setAttribute("ruta", $_POST['ruta']);


        $Acciones = $Doc->createElement("acciones");

        //Ver
        $Accion = $Doc->createElement("accion");
        $Accion->setAttribute("id", "ver");
        $Accion->setAttribute("tipo-respuesta", "pagina");
        $Accion->setAttribute("archivo", "formulario.php");
        $Accion->setAttribute("permiso-individual", "N");
        $Accion->setAttribute("predeterminada", "S");
        $Acciones->appendChild($Accion);


        $XmlAcciones = array_merge(['listar', 'asignar', 'agregar', 'modificar', 'eliminar'], $XmlAcciones);


        foreach ($XmlAcciones as $a) {
            $Accion = $Doc->createElement("accion");

            if (in_array($a, ['agregar', 'modificar', 'eliminar'])) {
                $PermisoIndividual = "S";
            } else {
                $PermisoIndividual = "N";
            }

            $Accion->setAttribute("id", $a);
            $Accion->setAttribute("tipo-respuesta", "json");
            $Accion->setAttribute("archivo", "acciones.php");
            $Accion->setAttribute("permiso-individual", $PermisoIndividual);
            $Acciones->appendChild($Accion);
        }

        $Item->appendChild($Acciones);
        $MenuPadre->appendChild($Item);
//        
        //var_dump($Menu);
        //var_dump($MenuPadre);
        $Doc->preserveWhiteSpace = false;
        $Doc->formatOutput = true;
        $Doc->save("menu.xml");

        $error = ob_get_contents();
        ob_clean();

        $r = [];
        if ($error === "") {
            $r['error'] = false;
            $r['msg'] = "Formulario CRUD creado con éxito !!! <br/><br/> "
                    . "<a target='_blank' href='" . SITE_PATH . $_POST['menu'] . "/ver'>Hacer click aquí para ver el formulario generado.</a>";
            $r['nodo'] = [
                "id" => "$_POST[menu]",
                "title" => "<b>$_POST[titulo_formulario]</b>",
                "folder" => false,
                "expanded" => false
            ];
        } else {
            $r['error'] = true;
            $r['msg'] = $error;
        }
        echo json_encode($r);
    }

    private function GenerarFormulario() {
        $db = $this->db;
        $BaseDeDatos = $this->BaseDeDatos;
        $Tabla = $this->Tabla;

        $Result = "";

        $sql = "SHOW COLUMNS FROM `$BaseDeDatos`.`$Tabla`";
        $rs = $db->query($sql);
        while ($rw = $db->fetch_assoc($rs)) {
            $Campo = $this->RID->GetRandID($rw['Field']);

            if (isset($_POST['formulario'][$Campo]) && $_POST['formulario'][$Campo] === "1") {

                $NombreCampo = $rw['Field'];
                $Titulo = $_POST['titulo'][$Campo];
//            $Obligatorio = (isset($_POST['obligatorio'][$Campo]) &&
//                    $_POST['obligatorio'][$Campo] === '1') ? '<span class="obligatorio"></span>' : '';
//                    
//                $Obligatorio = (isset($_POST['obligatorio'][$Campo]) &&
//                        $_POST['obligatorio'][$Campo] === '1') ? ' obligatorio' : '';

                $Obligatorio = "";
                $Modificable = (isset($_POST['modificable'][$Campo]) &&
                        $_POST['modificable'][$Campo] === '1') ? '' : ' no-modificable';

                // Ej: cambiar char(10) por char(10( para separar informacion
                $Tipo = str_replace(")", "(", $rw['Type']);
                $TipoExtra = explode("(", $Tipo);

                $TipoDato = $TipoExtra[0];
                $Longitud = (isset($TipoExtra[1]) && intval($TipoExtra[1]) > 0) ? intval($TipoExtra[1]) : 10;


                $sql = "SELECT 
                        * 
                    FROM 
                        information_schema.KEY_COLUMN_USAGE
                    WHERE
                        TABLE_SCHEMA='$BaseDeDatos'  AND
                        TABLE_NAME ='$Tabla' AND 
                        COLUMN_NAME='$NombreCampo' AND  
                        REFERENCED_TABLE_NAME IS NOT NULL
                    ";
                $LlaveForanea = $db->select_row($sql);

                $Validaciones = "";
                if (isset($_POST['obligatorio'][$Campo]) && $_POST['obligatorio'][$Campo] === '1') {
                    $Validaciones .= " required";
                }

                // echo "$NombreCampo ->  $TipoDato <br/>";

                switch ($TipoDato) {
                    case "smallint":
                    case "tinyint":
                    case "int":
                        $Validaciones .= " data-digits";
                        $TipoInput = "number";
                        break;

                    case "double unsigned":
                    case "decimal":
                    case "double":
                        $TipoInput = "number";
                        break;

                    case "date":
                        $TipoInput = "date";
                        break;

                    default:
                        $TipoInput = "text";
                        $Validaciones .= ' data-valid-text';
                        break;
                }

                if ($LlaveForanea != NULL) { //Llave foranea. Generar un objeto Select 
                    $Validaciones = strpos($Validaciones, "required") !== FALSE ? " required" : "";
                    $sql = "SHOW COLUMNS FROM `$LlaveForanea[REFERENCED_TABLE_SCHEMA]`.`$LlaveForanea[REFERENCED_TABLE_NAME]`";
                    $rs2 = $db->query($sql);
                    $rw2 = $db->fetch_assoc($rs2); // Pprimer camppo
                    $rw2 = $db->fetch_assoc($rs2); // Segundo campo

                    $Campo1 = "$LlaveForanea[REFERENCED_COLUMN_NAME]";
                    $Campo2 = $rw2['Field'];
                    $Tabla2 = "{$LlaveForanea['REFERENCED_TABLE_SCHEMA']}.{$LlaveForanea['REFERENCED_TABLE_NAME']}";
                    
                    $sql = "SELECT $Campo1, $Campo2 FROM $Tabla2 ORDER BY $Campo2 LIMIT 1000";
                    if (isset($_POST['tipo_formulario']) && $_POST['tipo_formulario'] == "HORIZONTAL") {
                        $Texto = '
                <div class="form-group row">
                    <label class="control-label col-sm-%4$s%3$s" for="%1$s">%2$s</label>
                    <div class="col-sm-%5$s">
                        <select name="%1$s" id="%1$s" class="form-control form-control-sm%6$s"%8$s>
                            <option value="">(Seleccionar %2$s)</option>
                            <?php
                            llenar_combo("%7$s");
                            ?>
                        </select>
                        <div class="help-block with-errors"></div>
                    </div> 
                </div>';
                    } else {
                        $Texto = '
                <div class="form-group">
                    <label class="control-label" for="%1$s">%2$s</label>
                    <select name="%1$s" id="%1$s" class="form-control form-control-sm%6$s"%8$s>
                        <option value="">(Seleccionar %2$s)</option>
                        <?php
                        llenar_combo("%7$s");
                        ?>
                    </select>
                    <div class="help-block with-errors"></div>
                </div>';
                    }


                    $Texto = sprintf($Texto, $NombreCampo, $Titulo, $Obligatorio, $_POST['cols_titulo'], $_POST['cols_objeto'], $Modificable, $sql, $Validaciones);
                } elseif (substr($rw['Type'], 0, 4) === "enum") {
                    // echo $rw['Type'];
                    $Enum = trim(substr($rw['Type'], 4), "()");
                    $Opciones = explode(",", $Enum);

                    $TextoOpciones = "";
                    foreach ($Opciones as $Opcion) {
                        $Opcion = trim($Opcion, "'");
                        $TextoOpciones .= "\t\t\t\t<option value=\"$Opcion\">$Opcion</option>\n";
                    }


                    if (isset($_POST['tipo_formulario']) && $_POST['tipo_formulario'] == "HORIZONTAL") {
                        $Texto = '
                <div class="form-group row">
                    <label class="control-label col-sm-%4$s%3$s" for="%1$s">%2$s</label>
                    <div class="col-sm-%5$s">
                        <select name="%1$s" id="%1$s" class="form-control form-control-sm%6$s"%8$s>
                            <option value="">(Seleccionar %2$s)</option>
%7$s
                        </select>
                        <div class="help-block with-errors"></div>
                    </div> 
                </div>';
                    } else {
                        $Texto = '
                <div class="form-group">
                    <label class="control-label for="%1$s">%2$s</label>
                    <select name="%1$s" id="%1$s" class="form-control form-control-sm%6$s"%8$s>
                        <option value="">(Seleccionar %2$s)</option>
%7$s
                    </select>
                    <div class="help-block with-errors"></div>
 
                </div>';
                    }

                    $Texto = sprintf($Texto, $NombreCampo, $Titulo, $Obligatorio, $_POST['cols_titulo'], $_POST['cols_objeto'], $Modificable, $TextoOpciones, $Validaciones);
                } else { //Generar objeto input
                    if (isset($_POST['tipo_formulario']) && $_POST['tipo_formulario'] == "HORIZONTAL") {
                        $Texto = '
                <div class="form-group row">
                    <label class="control-label col-sm-%4$s%3$s" for="%1$s">%2$s</label>
                    <div class="col-sm-%5$s">
                        <input type="%9$s" id="%1$s" name="%1$s" class="form-control form-control-sm%6$s" maxlength="%7$s" placeholder="%2$s"%8$s/>
                        <div class="help-block with-errors"></div>
                    </div>
                </div>';
                    } else {
                        $Texto = '
                <div class="form-group">
                    <label class="control-label" for="%1$s">%2$s</label>
                    <input type="%9$s" id="%1$s" name="%1$s" class="form-control form-control-sm%6$s" maxlength="%7$s" placeholder="%2$s"%8$s/>
                    <div class="help-block with-errors"></div>
                </div>';
                    }

                    $Texto = sprintf($Texto, $NombreCampo, $Titulo, $Obligatorio, $_POST['cols_titulo'], $_POST['cols_objeto'], $Modificable, $Longitud, $Validaciones, $TipoInput);
                }

                $Result .= $Texto;
            }
        }

        return $Result;
    }

    private function GenerarAcciones() {
        $db = $this->db;
        $BaseDeDatos = $this->BaseDeDatos;
        $Tabla = $this->Tabla;

        $Agregar = "";
        $Modificar = "";
        $Asignar = "";

        $sql = "SHOW COLUMNS FROM `$BaseDeDatos`.`$Tabla`";
        $rs = $db->query($sql);
        while ($rw = $db->fetch_assoc($rs)) {
            $Campo = $this->RID->GetRandId($rw['Field']);
            if (isset($_POST['formulario'][$Campo]) && $_POST['formulario'][$Campo] === "1") {
                $NombreCampo = $rw['Field'];

                $sql = "SELECT 
                        * 
                    FROM 
                        information_schema.KEY_COLUMN_USAGE
                    WHERE
                        TABLE_SCHEMA='$BaseDeDatos'  AND
                        TABLE_NAME ='$Tabla' AND 
                        COLUMN_NAME='$NombreCampo' AND  
                        REFERENCED_TABLE_NAME IS NOT NULL
                    ";
                $LlaveForanea = $db->select_row($sql);

                $Texto = "";
                if ($LlaveForanea != NULL) { //Llave foranea.
                    $Texto = "\t\$Row['{$NombreCampo}'] = \$RID->GetValue(\$_POST['{$NombreCampo}']);\n";
                    $Asignar .= "\t\$Row['{$NombreCampo}'] = \$RID->GetRandId(\$Row['{$NombreCampo}']);\n";
                } else {
                    $Texto = "\t\$Row['{$NombreCampo}'] = \$_POST['{$NombreCampo}'];\n";
                }
                $Agregar .= "$Texto";

                $Modificable = (isset($_POST['modificable'][$Campo]) && $_POST['modificable'][$Campo] === '1') ? '' : '//';
                $Modificar .= "{$Modificable}{$Texto}";
            }
        }

        if ($_POST['auditar'] === "S") {
            $Agregar .= "\t\$Row['_usuario_creacion'] = \$_SESSION['usuario']; \n\t\$Row['_fecha_creacion'] = date('Y-m-d H:i:s');";
            $Modificar .= "\t\$Row['_usuario_modificacion'] = \$_SESSION['usuario']; \n\t\$Row['_fecha_modificacion'] = date('Y-m-d H:i:s');";
        }

        return ["Agregar" => $Agregar, "Modificar" => $Modificar, "Asignar" => $Asignar];
    }

    function GenerarValidaciones() {
        $db = $this->db;
        $BaseDeDatos = $this->BaseDeDatos;
        $Tabla = $this->Tabla;

        $Validaciones = "";
        $sql = "SHOW COLUMNS FROM `$BaseDeDatos`.`$Tabla`";
        $rs = $db->query($sql);
        while ($rw = $db->fetch_assoc($rs)) {
            $Campo = $this->RID->GetRandId($rw['Field']);
            if (isset($_POST['formulario'][$Campo]) && $_POST['formulario'][$Campo] === "1") {
                $Texto = "";
                $Titulo = $_POST['titulo'][$Campo];
                $NombreCampo = $rw['Field'];
                $sql = "SELECT 
                        * 
                    FROM 
                        information_schema.KEY_COLUMN_USAGE
                    WHERE
                        TABLE_SCHEMA='$BaseDeDatos'  AND
                        TABLE_NAME ='$Tabla' AND 
                        COLUMN_NAME='$NombreCampo' AND  
                        REFERENCED_TABLE_NAME IS NOT NULL
                    ";
                $LlaveForanea = $db->select_row($sql);

                $InfoTipo = explode("(", $rw['Type']);
                $Tipo = $InfoTipo[0];
                $Longitud = (isset($InfoTipo[1]) && intval($InfoTipo[1]) > 0) ? intval($InfoTipo[1]) : 10;

                if (isset($_POST['obligatorio'][$Campo]) && $_POST['obligatorio'][$Campo] === '1') {
                    $Texto .= "'Required', ";
                }

                if ($LlaveForanea === NULL && substr($rw['Type'], 0, 4) !== "enum") {

                    $Texto .= "'ValidText', 'MaxLength' => $Longitud, ";
                    switch ($Tipo) {
                        case "smallint":
                        case "tinyint":
                        case "int":
                            $Texto .= "'Integer', ";
                            break;

                        case "double unsigned":
                        case "decimal":
                        case "double":
                            $Texto .= "'Decimal', ";
                            break;

                        case "date":
                            $Texto .= "'Date', ";
                            break;
                    }
                }
                $Texto = trim($Texto, ", ");
                $Validaciones .= "\t\t\$v->AddRules('$NombreCampo', '$Titulo', [$Texto]);\n";
            }
        }

        return $Validaciones;
    }

    function GenerarGrid() {
        $db = $this->db;
        $BaseDeDatos = $this->BaseDeDatos;
        $Tabla = $this->Tabla;

        $sql = "SHOW COLUMNS FROM `$BaseDeDatos`.`$Tabla`";
        $rs = $db->query($sql);

        $Campos = "";
        $PhpFiltros = "";
        $SqlFiltros = "";
        $PhpEjecutar = "";
        $PhpAcciones = "";
        $XmlAcciones = [];
        while ($rw = $db->fetch_assoc($rs)) {
            $Campo = $this->RID->GetRandId($rw['Field']);
            if (isset($_POST['incluir_grid'][$Campo]) == "1") {
                $Texto = "";
                $Titulo = $_POST['titulo'][$Campo];
                $NombreCampo = $rw['Field'];
                $sql = "SELECT 
                        * 
                    FROM 
                        information_schema.KEY_COLUMN_USAGE
                    WHERE
                        TABLE_SCHEMA='$BaseDeDatos'  AND
                        TABLE_NAME ='$Tabla' AND 
                        COLUMN_NAME='$NombreCampo' AND  
                        REFERENCED_TABLE_NAME IS NOT NULL
                    ";
                $LlaveForanea = $db->select_row($sql);

                //var_dump($LlaveForanea);
                $InfoTipo = explode("(", $rw['Type']);
                $Tipo = $InfoTipo[0];

                $Width = $_POST['grid'][$Campo];
                $Filtro = "";
                if (isset($_POST['filtro'][$Campo]) && $_POST['filtro'][$Campo] === "1") {

                    if ($LlaveForanea === NULL) {
                        $Filtro = " data-filter-type=\"text\"";
                        $PhpFiltros .= "\n\tif (isset(\$f['$NombreCampo']) && \$f['$NombreCampo'] !== \"\") {\n" .
                                "\t\t\$q = str_replace(' ', '%', \$f['$NombreCampo']);\n" .
                                "\t\t\$filtros .= \" AND $NombreCampo LIKE '%\$q%' \";\n" .
                                "\t}\n";
                    } else {
                        $NombreAccion = "listar-$NombreCampo";
                        $NombreAccion = str_replace("_", "-", $NombreAccion);
                        $XmlAcciones[] = $NombreAccion;


                        $Filtro = " data-filter-type=\"select\" "
                                . "\n\t\tdata-filter-source=\"<?php echo PAGE_PATH . \"$NombreAccion\" ?>\"";

                        $PhpFiltros .= "\n\tif (isset(\$f['$NombreCampo']) && \$f['$NombreCampo'] !== \"\") {\n" .
                                "\t\t\$q = \$RID->GetValue(\$f['$NombreCampo']);" .
                                "\t\t\$filtros .= \" AND $NombreCampo = '\$q' \";\n" .
                                "\t}\n";


                        $NombreFuncion = "";
                        $Partes = explode("-", $NombreAccion);
                        foreach ($Partes as $p) {
                            $NombreFuncion .= mb_convert_case($p, MB_CASE_TITLE);
                        }

                        $PhpEjecutar .= "\n\t\tcase \"$NombreAccion\":\n"
                                . "\t\t\t\$this->$NombreFuncion();\n"
                                . "\t\t\tbreak;\n";

                        $FkDb = $LlaveForanea['REFERENCED_TABLE_SCHEMA'];
                        $FkTabla = $LlaveForanea['REFERENCED_TABLE_NAME'];
                        $FkCampo1 = $LlaveForanea['REFERENCED_COLUMN_NAME'];
                        $sql = "SELECT COLUMN_NAME 
                            FROM information_schema.COLUMNS 
                            WHERE TABLE_SCHEMA = '$FkDb' AND TABLE_NAME = '$FkTabla' LIMIT 1 OFFSET 1";
                        $FkCampo2 = $db->select_one($sql);
                        $FkCampo2 = ($FkCampo2 === NULL) ? $FkCampo1 : $FkCampo2;


                        $PhpAcciones .= "\n    function $NombreFuncion() {
        \$db = \$this->db;
        \$sql = \"SELECT $FkCampo1 AS value, $FkCampo2 AS text FROM $FkDb.$FkTabla ORDER BY $FkCampo2 DESC\";
        \$data = [];
        \$rs = \$db->query(\$sql);
        while (\$rw = \$db->fetch_assoc(\$rs)) {
            \$rw['value'] = \$this->RID->GetRandId(\$rw['value']);
            \$data[] = \$rw;
        }
        echo json_encode(\$data);
    }\n";
                    }
                }
                $Campos .= "\t\t<th data-field=\"$NombreCampo\" data-width=\"$Width\"$Filtro>$Titulo</th>\n";
            }
        }

        $SqlWhere = "";
        if ($PhpFiltros !== "") {
            $PhpFiltros = "\n\t\$filtros = \"\"; \n"
                    . "\tif (ACCION == \"listar\" && isset(\$_GET['filters']) && is_array(\$_GET['filters'])) {\n"
                    . "\t\$f = \$_GET['filters'];\n"
                    . $PhpFiltros
                    . "\n\t}";

            $SqlFiltros = "WHERE 1 \$filtros";
        }

        return ["Campos" => $Campos,
            "PhpFiltros" => $PhpFiltros,
            "SqlFiltros" => $SqlFiltros,
            "PhpEjecutar" => $PhpEjecutar,
            "PhpAcciones" => $PhpAcciones,
            "XmlAcciones" => $XmlAcciones];
    }

}

$f = new Formulario();
$f->Ejecutar(ACCION);

