<?php
if ($_SESSION['clave_vencida'] == "1") {
    ?>
    <div class="alert alert-warning" role="alert">
        <span class="glyphicon glyphicon-exclamation-sign" aria-hidden="true"></span>
        <span class="sr-only">Advertencia:</span>
        Su contraseña de acceso ha vencido. 
        Por motivos de seguridad es obligatorio cambiarla antes de continuar.
    </div>

    <?php
}
?>

<div style="max-width:500px; margin:auto; margin-top: 20px">
    <div class="card card-custom" id="div-sesion">
        <div class="card-header px-3 py-1">
            <h3 class="panel-title">Cambiar mi contraseña</h3>
        </div>

        <div class="card-body">
            <form id="formulario">
                <div class="form-group ">
                    <label for="clave1" class="obligatorio">Contraseña actual</label>
                    <input type="password" id="clave1" name="clave1" 
                           class="form-control form-control-sm" maxlength="16" value="deinermena" 
                           placeholder="Contraseña actual">
                </div>

                <div class="form-group ">
                    <label for="clave2" class="obligatorio">Nueva contraseña</label>
                    <input type="password" id="clave2" name="clave2" 
                           class="form-control form-control-sm" maxlength="16" value="deiner" 
                           placeholder="Nueva contraseña">
                </div>

                <div class="form-group ">
                    <label for="clave3" class="obligatorio">Repetir nueva contraseña</label>
                    <input type="password" id="clave3" name="clave3" class="form-control form-control-sm" 
                           maxlength="16" value="deiner"  
                           placeholder="Repetir nueva contraseña">
                </div>
            </form>
            <div class="form-group">
                <button type="button" class="btn btn-full btn-danger" id="btn-cambiar">Cambiar mi contraseña</button> 
            </div>

            <div class="working no-show"></div>

        </div>
    </div>
</div>

<script>
    $("#btn-cambiar").click(function () {
        bootbox.confirm("¿Realmente desea cambiar su contraseña de ingreso?", function (result) {
            if (result === true) {
                $("#btn-cambiar").hide();
                $(".working").show();
                var datos = $("#formulario").serialize();
                $.post(PAGE_PATH + "cambiar", datos, function (data) {
                    $("#btn-cambiar").show();
                    $(".working").hide();
                    var r = jQuery.parseJSON(data);
                    if (r.error === true) {
                        $.notify({message: r.msg}, {type: 'danger', delay: 0});
                    } else {
                        bootbox.alert(r.msg, function () {
                            window.location.replace(PAGE_PATH+ "../../");
                        });
                    }
                });
            }
        });
    });
</script> 
