<?php

class DesbloquearUsuario {
    /* @var $db DbMySQL */

    protected $db;
    protected $RID;

    public function __construct() {

        $this->db = $GLOBALS['db'];
        $this->RID = new RandId(MENU);
    }

    function Ejecutar($Accion) {
        switch ($Accion) {
            case "listar":
                $this->Listar();
                break;

            case "desbloquear":
                $this->Desbloquear();
                break;

            case "asignar":
                $this->Asignar();
                break;

            case "listar":
                $this->Listar();
                break;
        }
    }

    function Validar() {
        $v = new Validation($_POST);
        $v->AddRules('id', '', ['Required']);

        $result = $v->Validate();
        if ($result['messages'] !== "") {
            //Errores de validación
            $r['error'] = true;
            $r['msg'] = $result['messages'];
            $r['bad_fields'] = $result['bad_fields'];
            $r['errors'] = $result['errors'];
            echo json_encode($r);
            exit(0);
        }
        return true;
    }

    protected function GetSQL() {
        $filtro = "";

        if (ACCION == "listar" && isset($_GET['filters']) && is_array($_GET['filters'])) {
            $f = $_GET['filters'];

            if (isset($f['usuario']) && $f['usuario'] !== "") {
                $q = str_replace(" ", "%", $f['usuario']);
                $filtro .= " AND bu.usuario   LIKE '%$q%' ";
            }

            if (isset($f['identifica']) && $f['identifica'] !== "") {
                $q = str_replace(" ", "%", $f['identifica']);
                $filtro .= " AND p.identifica   LIKE '%$q%' ";
            }

            if (isset($f['nombre']) && $f['nombre'] !== "") {
                $q = str_replace(" ", "%", $f['nombre']);
                $filtro .= " AND  CONCAT_WS(' ', p.nombre1, p.nombre2, p.apellido1, p.apellido2) LIKE '%$q%' ";
            }
        }

        $sql = "SELECT 
                    bu.id,
                    bu.usuario,
                    p.identifica,
                    CONCAT_WS(' ',
                            p.nombre1,
                            p.nombre2,
                            p.apellido1,
                            p.apellido2) AS nombre,
                    tb.nombre AS motivo,
                    bu.fecha
                FROM
                    admin_bloqueo_usuario bu
                        JOIN
                    persona p ON bu.identifica = p.identifica
                        JOIN
                    admin_tipo_bloqueo tb ON bu.tipo_bloqueo = tb.id
                WHERE
                    bu.activo = 'SI'
                    $filtro
                ORDER BY bu.id DESC";
        return $sql;
    }

    protected function GetFila($Id = NULL) {
        $db = $this->db;
        $sql_base = $this->GetSQL();

        if ($Id == NULL) {
            $Id = $db->last_insert_id();
        }

        $sql = "SELECT * FROM ($sql_base) AS t WHERE id='$Id' ";
        $row = $db->select_row($sql);
        $row['id'] = $this->RID->GetRandId($Id);
        return $row;
    }

    function Listar() {
        $db = $this->db;
        //
        $sql = $this->GetSQL();
        $result['total'] = $db->count_rows($sql);
        $offset = $_GET['offset'];
        $limit = $_GET['limit'];
        $rs = $db->select_limit($sql, $limit, $offset);
        //  
        $result['rows'] = array();
        $num = $offset + 1;
        while ($rw = $db->fetch_assoc($rs)) {
            $rw['id'] = $this->RID->GetRandId($rw['id']);
            $rw['_NUM_'] = $num++;
            $result['rows'][] = $rw;
        }
        echo json_encode($result);
    }

    function Asignar() {
        $db = $this->db;
        $RID = $this->RID;
        //
        $Id = $RID->GetValue($_GET['id']);
        //
        $sql = "SELECT 
                    bu.id,
                    bu.usuario,
                    p.identifica,
                    CONCAT_WS(' ',
                            p.nombre1,
                            p.nombre2,
                            p.apellido1,
                            p.apellido2) AS nombre,
                    tb.nombre AS motivo,
                    bu.fecha
                FROM
                    admin_bloqueo_usuario bu
                        JOIN
                    persona p ON bu.identifica = p.identifica
                        JOIN
                    admin_tipo_bloqueo tb ON bu.tipo_bloqueo = tb.id
                WHERE
                    bu.id = '$Id'";

        $rw = $db->select_row($sql);
        $rw['id'] = $_GET['id'];

        echo json_encode($rw);
    }

    function Desbloquear() {
        $db = $this->db;
        $RID = $this->RID;
        $this->Validar();
        //
        $Id = $RID->GetValue($_POST['id']);
        //

        $sql = "UPDATE admin_bloqueo_usuario
                SET 
                        _fecha_desbloqueo=NOW(), 
                        _usuario_desbloqueo = '$_SESSION[usuario]' ,
                        activo='NO'
                WHERE
                   id='$Id'
                ";

        $db->query($sql);

        $r = array();
        if ($db->error()) {
            $r['error'] = true;
            $r['msg'] = $db->error();
        } else {
            $r['error'] = false;
            $r['msg'] = "Usuario desbloqueado con éxito.";
            $r['row'] = $this->GetFila($Id);
        }
        echo json_encode($r);
    }

}

$f = new DesbloquearUsuario();
$f->Ejecutar(ACCION);
?>