 
<div id="div-grid">
    <div id="toolbar">
        <div class="pull-left titulo">
            Desbloquear usuario
        </div>

    </div>

    <table id="tabla"
           data-toggle="table"
           data-toolbar="#toolbar"
           data-pagination="true"
           data-side-pagination="server"
           data-page-size="50"
           data-page-list="[]"
           data-id-field="id"
           data-unique-id="id"
           data-url ="<?php echo PAGE_PATH . "listar" ?>"
           data-search="false"
           data-height="300"
           data-row-style="setRowStyle"
           data-mobile-responsive="true">
        <thead>
            <tr>
                <th data-field="_NUM_" data-width="60px">No</th>
                <th data-field="usuario" data-width="90px" data-filter-type="text">Usuario</th>
                
                <th data-field="identifica" data-width="100px" data-filter-type="text">Identifica</th>
                <th data-field="nombre" data-width="" data-filter-type="text">Nombre</th>
                <th data-field="motivo" data-width="200px">Motivo</th>
                <th data-field="fecha" data-width="140px" >Fecha</th>
                <th data-field="acciones" data-formatter="operateFormatter"  
                    data-events="operateEvents" 
                    data-align="center"
                    data-width="60px"
                    >Acciones</th>
            </tr>
        </thead>

    </table>
</div>

<div id="div-formulario">
    <div class="card card-custom card-700">
        <div class="card-header px-3 py-1">
            <div class="card-title">
                Desbloquear usuario
            </div>
        </div>
        <div class="card-body">
            <form class="form-horizontal" id="formulario" >
                <input type="hidden" id="id" name="id" />

                <div class="form-group row">
                    <label class="col-sm-2 col-form-label col-form-label-sm" for="usuario">Usuario</label>
                    <div class="col-sm-10">
                        <input id="usuario" name="usuario" class="form-control form-control-sm no-modificable"/>
                    </div>
                </div>

                <div class="form-group row">
                    <label class="col-sm-2 col-form-label col-form-label-sm" for="usuario">Fecha</label>
                    <div class="col-sm-10">
                        <input id="fecha" name="fecha" class="form-control form-control-sm  no-modificable"/>
                    </div>
                </div>


                <div class="form-group row">
                    <label class="col-sm-2 col-form-label col-form-label-sm" for="identifica">Identifica</label>
                    <div class="col-sm-10">
                        <input id="identifica" name="identifica" class="form-control form-control-sm  no-modificable"/>
                    </div>
                </div>


                <div class="form-group row">
                    <label class="col-sm-2 col-form-label col-form-label-sm " for="nombre">Nombre</label>
                    <div class="col-sm-10">
                        <input id="nombre" name="nombre" class="form-control form-control-sm no-modificable"/>
                    </div>
                </div>



                <div class="form-group row">
                    <label class="col-sm-2 col-form-label col-form-label-sm" for="motivo">Motivo</label>
                    <div class="col-sm-10">
                        <input id="motivo" name="motivo" class="form-control form-control-sm  no-modificable"/>
                    </div>
                </div>


                <div class="form-group action-buttons row mb-0">        
                    <div class="offset-sm-2 col-sm-10">
                        <input type="button" class="btn btn-sm btn-success btn-aceptar" value="Desbloquear">
                        <input type="button" class="btn btn-sm btn-default btn-regresar" value="Regresar">
                    </div>
                </div>
                <div class="working no-show"></div>
            </form>
        </div>
    </div>


</div>

<script type="text/javascript">
    var f = new Formulario();

    f.Desbloquear = function (e, value, row, index) {
        var Obj = f;
        var SelectedRows = Obj.$table.bootstrapTable("getSelections");
        if (SelectedRows.length > 0) {
            row = SelectedRows[0];
        }

        var RowId = row[Obj.PKey];

        Obj.Limpiar();
        Obj.MostrarFormulario("Desbloquear");
        Obj.DesbloquearEntradas();
        Obj.Asignar(RowId);
        Obj.BloquearNoModifibles();

        $(".btn-aceptar").click(function () {
            bootbox.confirm("¿Realmente desea desbloquear el usuario?", function (result) {
                if (result === true) {
                    $(".action-buttons").hide();
                    $(".working").show();
                    //window.scrollTo(0, 0);
                    $.post(PAGE_PATH + "desbloquear", Obj.Valores(), function (Data) {
                        $(".working").hide();
                        $(".action-buttons").show();
                        try {
                            var r = jQuery.parseJSON(Data);
                            if (r.error === false) {
                                r.row.addrow = true;
                                Obj.$table.bootstrapTable('removeByUniqueId', RowId);
                                //Obj.$table.bootstrapTable('updateByUniqueId', {id: RowId, row: r.row});
                                $("#div-formulario").hide();
                                $("#div-grid").show();
                                $(window).trigger("resize"); //Causar que se acutalice tamaño del Grid
                                $.notifyClose();
                                $.notify({message: r.msg}, {type: 'success'});
                            } else {
                                $.notify({message: r.msg}, {type: 'danger', delay: 0});
                            }
                        } catch (Err) {
                            $.notify({message: Err.message + "<br/>" + Data}, {type: 'danger', delay: 0});
                        }
                    });
                }
            });
        });

    };

    window.operateFormatter = function (value, row, index) {
        var iconos = "";
        iconos += " <a class='fa fa-check-circle desbloquear' title='Desbloquear'></a> ";
        return iconos;
    };

    window.operateEvents = {
        'click .desbloquear': f.Desbloquear
    };

</script>
