<?php

class Rol {
    /* @var $db DbMySQL */

    protected $db;
    protected $RID;

    public function __construct() {
        $this->db = $GLOBALS['db'];
        $this->RID = new RandId();
    }

    function Validar() {
        $v = new Validation($_POST);
        $v->addRules('rol', 'Rol', array('required' => true));

        $result = $v->validate();
        if ($result['messages'] == "") {//No hay errores de validacion
            return true;
        } else { //Errores de validación
            $r['error'] = true;
            $r['msg'] = $result['messages'];
            $r['bad_fields'] = $result['bad_fields'];
            $r['errors'] = $result['errors'];
            echo json_encode($r);
            exit(0);
        }
        return true;
    }

    function Ejecutar($Accion) {
        switch ($Accion) {
            case "cargar":
                $this->Cargar();
                break;
            case "guardar":
                $this->Guardar();
                break;
        }
    }

    function Guardar() {
        $db = $this->db;

        $this->Validar();

        $rol = $this->RID->GetValue($_POST['rol']);

        $db->start_transaction();
        $db->query("DELETE FROM admin_permiso_menu WHERE rol='$rol'");
        $db->query("DELETE FROM admin_permiso_accion WHERE rol='$rol'");

        if (isset($_POST['menu']) && is_array($_POST['menu'])) {
            foreach ($_POST['menu'] as $menu) {
                $row = [];
                $row['rol'] = $rol;
                $row['menu'] = $menu;
                $row['_usuario'] = $_SESSION['usuario'];
                $db->insert("admin_permiso_menu", $row);
            }
        }
        if (isset($_POST['acciones']) && is_array($_POST['acciones'])) {
            foreach ($_POST['acciones'] as $menu => $acciones) {
                foreach ($acciones as $accion) {
                    $row = [];
                    $row['rol'] = $rol;
                    $row['menu'] = $menu;
                    $row['accion'] = $accion;
                    $row['_usuario'] = $_SESSION['usuario'];
                    $db->insert("admin_permiso_accion", $row);
                }
            }
        }

        $result = [];
        if ($db->trans_num_errors() === 0) {
            $result['error'] = false;
            $result['msg'] = "Cambios guardados con éxito";
            $db->commit();
        } else {
            $result['error'] = true;
            $result['msg'] = substr($db->trans_errors(), 0, 200);
            $db->rollback();
        }
        echo json_encode($result);
        //print_r($_POST);
    }

    function Cargar() {

        /* @var $Menu Menu */
        global $Menu;
        global $MenuArray;
        global $RsMenu;
        global $RsAccion;
        $db = $this->db;
        $RID = $this->RID;


        $rol = $RID->GetValue($_GET['rol']);

        $RsMenu = [];

        $rs = $db->query("SELECT * FROM admin_permiso_menu WHERE rol='$rol'");
        while ($rw = $db->fetch_assoc($rs)) {
            $m = $rw['menu'];
            $RsMenu [$m] = true;
        }

        $RsAccion = [];
        $rs = $db->query("SELECT * FROM admin_permiso_accion WHERE rol='$rol'");
        while ($rw = $db->fetch_assoc($rs)) {
            $m = $rw['menu'];
            $a = $rw['accion'];
            $RsAccion [$m][$a] = true;
        }
        //echo json_encode($RsMenu);

        $MenuArray = $Menu->GetMenuArray();
        $json = $this->GenerarJSON();
        echo json_encode($json);
    }

    private function GenerarJSON($Padre = "", $Nivel = 1) {
        global $MenuArray, $RsMenu, $RsAccion;
        if ($Nivel > 4) {
            return [];
        }
        $r = array();

        foreach ($MenuArray as $m) {
            if ($m['padre'] === $Padre && $m['tipo-acceso'] === "7") {
                $item = [];
                //$item['id'] = $m['id'];
                //$item['title'] = "<input type='input' name='node1info'> $m[titulo]";
                $item['title'] = "$m[titulo]";
                $item['folder'] = true;
                $item['expanded'] = false;
                $item['key'] = $m['id'];
                $item['tipo'] = "menu";

                $item['selected'] = isset($RsMenu[$m['id']]);
                $item['children'] = [];

                if (isset($m['acciones']) === true) {
                    foreach ($m['acciones'] as $accion) {
                        if (isset($accion['permiso-individual']) && $accion['permiso-individual'] === "S") {
                            $a = array();
                            //$a['id'] = $accion['id'];
                            $a['title'] = $accion['id'];
                            $a['folder'] = false;
                            $a['expanded'] = false;

                            $a['tipo'] = "accion";
                            $a['menu'] = $m['id'];
                            $a['key'] = $accion['id'];

                            $a['selected'] = isset($RsAccion[$m['id']]) && isset($RsAccion[$m['id']][$accion['id']]);
                            $item['children'][] = $a;
                        }
                    }
                } else {
                    $item['children'] = $this->GenerarJSON($m['id'], $Nivel + 1);
                    //                }
                }

                if (count($item['children']) === 0) {
                    unset($item['children']);
                }
                $r[] = $item;
            }
        }
        return $r;
    }

}

$f = new Rol();
$f->Ejecutar(ACCION);

