<?php

class Rol {
    /* @var $db DbMySQL */

    protected $db;
    protected $RID;
    protected $AutoIcrement;

    public function __construct() {

        $this->db = $GLOBALS['db'];
        $this->RID = new RandId(MENU);
    }

    function Ejecutar($Accion) {
        switch ($Accion) {
            case "Listar":
                $this->Listar();
                break;

            case "agregar":
                $this->Agregar();
                break;

            case "asignar":
                $this->Asignar();
                break;

            case "listar":
                $this->Listar();
                break;

            case "modificar":
                $this->Modificar();
                break;

            case "eliminar":
                $this->Eliminar($_POST);
                break;
        }
    }

    function Validar() {
        $v = new Validation($_POST);
        $v->addRules('nombre', 'Nombre', array('required' => true));
        $v->addRules('activo', 'Activo', array('required' => true));
        $v->addRules('dias_vencimiento_clave', 'Vencimiento', array('required' => true, 'digits' => true));

        $result = $v->validate();
        if ($result['messages'] == "") {//No hay errores de validacion
            return true;
        } else { //Errores de validación
            $r['error'] = true;
            $r['msg'] = $result['messages'];
            $r['bad_fields'] = $result['bad_fields'];
            $r['errors'] = $result['errors'];
            echo json_encode($r);
            exit(0);
        }
        return true;
    }

    protected function GetSQL() {
        $sql = "SELECT 
                   id, 
                   nombre,
                   CONCAT_WS(' ',dias_vencimiento_clave,'días ') dias_vencimiento_clave, 
                   activo
                FROM
                    admin_rol ";
        return $sql;
    }

    protected function GetFila($Id = NULL) {
        $db = $this->db;
        $sql_base = $this->GetSQL();

        if ($Id == NULL) {
            $Id = $db->last_insert_id();
        }

        $sql = "SELECT * FROM ($sql_base) AS t WHERE id='$Id' ";
        $row = $db->select_row($sql);
        $row['id'] = $this->RID->GetRandId($Id);
        return $row;
    }

    function Listar() {
        $db = $this->db;
        $sql = $this->GetSQL();
        $result['total'] = $db->count_rows($sql);
        $offset = $_GET['offset'];
        $limit = $_GET['limit'];

        $rs = $db->select_limit($sql, $limit, $offset);

        echo $db->error();


        $result['rows'] = array();
        $num = $offset + 1;
        while ($rw = $db->fetch_assoc($rs)) {
            $rw['id'] = $this->RID->GetRandId($rw['id']);
            $rw['_NUM_'] = $num++;
            $result['rows'][] = $rw;
        }
        //$result['rows'] = $this->db->fetch_all($rs);
        echo json_encode($result);
    }

    function Agregar() {
        $db = $this->db;
        $this->Validar();

        $row = [];
        //$row['id'] = $_POST['id'];
        $row['nombre'] = $_POST['nombre'];
        $row['activo'] = $_POST['activo'];
        $row['dias_vencimiento_clave'] = $_POST['dias_vencimiento_clave'];
        $row['_usuario_creacion'] = $_SESSION['usuario'];
        $row['_fecha_creacion'] = date('Y-m-d H:i:s');



        $db->insert('admin_rol', $row);
        //
        $result = array();
        if ($db->error()) {
            $result['error'] = true;
            $result['msg'] = $db->error();
        } else {
            $result['error'] = false;
            $result['msg'] = "Registro agregado con éxito";
            $result['row'] = $this->GetFila();
        }
        echo json_encode($result);
    }

    function Asignar() {
        $db = $this->db;
        $Id = $this->RID->GetValue($_GET['id']);

        $sql = "select * from admin_rol where id='$Id'";
        $rw = $db->select_row($sql);
        $rw['id'] = $_GET['id'];
        echo json_encode($rw);
    }

    function Modificar() {
        $db = $this->db;
        $this->Validar();

        $Id = $this->RID->GetValue($_POST['id']);

        $row = [];
        //$row['id'] = $Id;
        $row['nombre'] = $_POST['nombre'];
        $row['activo'] = $_POST['activo'];
        $row['dias_vencimiento_clave'] = $_POST['dias_vencimiento_clave'];
        $row['_usuario_modificacion'] = $_SESSION['usuario'];
        $row['_fecha_modificacion'] = date('Y-m-d H:i:s');

        $sql = $db->make_update("admin_rol", $row) . " where id='$Id'";
        $db->query($sql);

        $r = array();
        if ($db->error()) {
            $r['error'] = true;
            $r['msg'] = $db->error();
        } else {
            $r['error'] = false;
            $r['msg'] = "Registro modificado con éxito.";
            $r['row'] = $this->GetFila($Id);
        }
        echo json_encode($r);
    }

    function Eliminar() {
        $db = $this->db;
        $Id = $this->RID->GetValue($_POST['id']);
        $sql = "delete from admin_rol where id='$Id'";
        $db->query($sql);

        $r = array();
        if ($db->error()) {
            $r['error'] = true;
            $r['msg'] = $db->error();
        } else {
            $r['error'] = false;
            $r['msg'] = "Registro eliminado con éxito.";
        }
        echo json_encode($r);
    }

}

$f = new Rol();
$f->Ejecutar(ACCION);
?>