<?php

class Sesion {
    /* @var $db DbMySQL */

    private $db;
    private $RID;
    private $Usuario, $Identifica;

    public function __construct() {
        $this->db = $GLOBALS['db'];
        $this->RID = $GLOBALS['RID'];
    }

    function Validar() {

        $CampoUsuario = $_SESSION['CampoUsuario'];
        $CampoClave = $_SESSION['CampoClave'];

        $v = new Validation($_POST);
        $v->addRules($CampoUsuario, 'Usuario', ['required' => true,   'regExp' => "/^[0-9a-zA-ZZáéíóúñüÁÉÍÓÚÜÑñ]*$/"]);
        $v->addRules($CampoClave, 'Clave', ['required' => true,]);

        $result = $v->validate();
        if ($result['messages'] !== "") {
            //Errores de validación
            $r['error'] = true;
            $r['msg'] = $result['messages'];
            $r['bad_fields'] = $result['bad_fields'];
            $r['errors'] = $result['errors'];
            echo json_encode($r);
            exit(0);
        }

        return true;
    }

    function Ejecutar($Accion) {
        switch ($Accion) {
            case "iniciar":
                $this->Iniciar();
                break;
        }
    }

    function Iniciar() {

        $db = $this->db;

        $this->Validar();

        $CampoUsuario = $_SESSION['CampoUsuario'];
        $CampoClave = $_SESSION['CampoClave'];

        $Login = $_POST[$CampoUsuario];
        $Clave = $_POST[$CampoClave];

        $this->Usuario = $Login;

        $this->ExpirarBloqueos();
        $this->VerificarBloqueo();

        if (isset($_SESSION['usuario'])) {

            $this->DenegarSesion("Acceso denegado !!!", 3); //Ya habia iniciado sesión previamente
        }

        $sql = "SELECT 
                    p.id,
                    p.identifica,
                    p.nombre,
                    p.apellido,
                    p.clave
                FROM
                    persona p
                WHERE
                    p.identifica = '$Login'
                    ";

        if ($Usuario = $db->select_row($sql)) {

            $this->Identifica = $Usuario['identifica'];

            if (password_verify($Clave, $Usuario['clave']) === false) {
                $this->DenegarSesion("Acceso denegado !", 1); // Usuario o clave incorrecta
            }
        } else {
            $this->DenegarSesion("Acceso denegado !", 1); // Usuario o clave incorrecta
            //$this->DenegarSesion("Acceso denegado !", 2); // No tiene rol para este aplicativo
        }


        $row = array();
        $row['usuario'] = $Login;
        $row['identifica'] = $Usuario['identifica'];
        $row['user_agent'] = $db->escape_string($_SERVER['HTTP_USER_AGENT']);
        $row['refer'] = $_SERVER['HTTP_REFERER'];
        $row['ip'] = $_SERVER['REMOTE_ADDR'];
        $row['inicio'] = date('Y-m-d H:i:s');
        //$row['fin'] = date('Y-m-d H:i:s');
        $row['salida_segura'] = "NO";
        $db->insert("admin_sesion", $row);



        $id = $db->last_insert_id();
        if ($id === "" || $db->error() !== "") {
            // Error al crear la sesion en la base de datos
            $this->DenegarSesion($db->error() . " Acceso denegado!!!", 5);
        }

        //Datos de sesion
        $_SESSION['sesion_id'] = $id;
        $_SESSION['usuario'] = $Usuario['identifica'];
        $_SESSION['usuario_identifica'] = $Usuario['identifica'];
        $_SESSION['usuario_login'] = $Login;
        $_SESSION['nombre_usuario'] = substr($Usuario['nombre'],0, 40);  // mb_convert_case($Usuario['nombre'], MB_CASE_TITLE) . " " . mb_convert_case($Usuario['apellido1'], MB_CASE_TITLE);
        $_SESSION['persona_id'] = $Usuario['id'];
        $_SESSION['usuario_roles'] = "";
        $_SESSION['clave_vencida'] = 'NO'; // $ClaveVencida;
        //Determinar accesos
        $_SESSION['accesos_permitidos'] = [];
        $_SESSION['accesos_permitidos'][] = 1; //Permisos para todos los usuarios
        $_SESSION['accesos_permitidos'][] = 3; //Permisos para usuarios logueados
        $_SESSION['accesos_permitidos'][] = 4; //Permisos para estudiantes
        $_SESSION['accesos_permitidos'][] = 5; //Permisos para docentes
        $_SESSION['accesos_permitidos'][] = 6; //Permisos para administrativos



        $Roles = $db->select_one("SELECT GROUP_CONCAT(rol)  FROM admin_usuario_rol WHERE identifica='$Usuario[identifica]'");
        if ($Roles != "") {
            $_SESSION['accesos_permitidos'][] = 7; //Menus que dependen del rol
            $_SESSION['usuario_roles'] = $Roles;
        }
        //
        //Cargar configuración de usuario
        $_SESSION['configuracion'] = [];
        $rs = $db->query("SELECT * FROM admin_configuracion_usuario WHERE identifica='$Usuario[identifica]'");
        while ($rw = $db->fetch_assoc($rs)) {
            $variable = $rw['variable'];
            $valor = $rw['valor'];
            $_SESSION['configuracion'][$variable] = $valor;
        }

        $r = array();
        $r['error'] = false;
        $r['msg'] = "Ok";
        echo json_encode($r);
    }

    protected function DenegarSesion($msg, $tipo) {

        /*
         * Tipo
         * 1: Usuario o clave incorrecta
         * 2: No tiene rol para este aplicativo
         * 3: Ya habia iniciado sesión previamente
         * 4: Error de validación
         * 5: Error al crear la sesion en la base de datos
         * 6: Información de host no valida
         * 7: No hay ningun host autorizado
         * 8: Información del SO no coincide
         * 9: El Id del usuario difiere con el ID del certificado digital
         * 10: Usuario bloqueado
         * 11: Intento de ingreso con usuario antiguo
         */

        $db = $this->db;
        $row['usuario'] = $this->Usuario;
        $row['identifica'] = $this->Identifica;
        $row['user_agent'] = $db->escape_string($_SERVER['HTTP_USER_AGENT']);
        $row['refer'] = $_SERVER['HTTP_REFERER'];
        $row['ip'] = $_SERVER['REMOTE_ADDR'];
        $row['fecha'] = date('Y-m-d H:i:s');
        $row['tipo'] = $tipo;
        $db->insert("admin_sesion_denegada", $row);


        if ($this->Usuario !== "" && $this->Usuario != NULL) {
            $this->BloquearUsuario();
        }

        $r = array();
        $r['error'] = true;
        $r['msg'] = $msg . " ($tipo)";
        echo json_encode($r);
        exit(0);
    }

    protected function BloquearUsuario() {
        $db = $this->db;
        $Identifica = $this->Identifica;
        $Usuario = $this->Usuario;

        $sql0 = "SELECT fin FROM admin_sesion WHERE usuario = '$Usuario' ORDER BY fin DESC";



        $FechaUltimaSesion = $db->select_one($sql0);



        $sql1 = "SELECT * FROM admin_tipo_bloqueo WHERE activo ='SI' ORDER BY tiempo_observacion DESC";
        $rs = $db->query($sql1);
        while ($rw = $db->fetch_assoc($rs)) {
            $Tiempo = $rw['tiempo_observacion'] * 60; //Pasar de minutos a segundos
            $sql2 = "SELECT 
                        COUNT(*)
                    FROM
                        admin_sesion_denegada
                    WHERE
                        usuario = '$Usuario'
                            AND UNIX_TIMESTAMP() - UNIX_TIMESTAMP(fecha) <= $Tiempo
                            AND fecha>= '$FechaUltimaSesion'
                    ";
            $NumSesionesDenegadas = $db->select_one($sql2);

            //echo $num_sesiones_denegadas . "\n";
            if ($NumSesionesDenegadas >= $rw['num_sesiones_denegadas']) {
                $row = [];
                $TipoBloqueo = $rw['id'];
                $row['identifica'] = $Identifica;
                $row['usuario'] = $Usuario;
                $row['tipo_bloqueo'] = $TipoBloqueo;
                $row['fecha'] = date('Y-m-d H:i:s');
                $row['activo'] = 'SI';

                $db->insert("admin_bloqueo_usuario", $row);

                $r = array();
                $r['error'] = true;
                $r['msg'] = "Usuario bloqueado ($TipoBloqueo)";
                echo json_encode($r);
                exit(0);
            }
        }
    }

    protected function VerificarBloqueo() {
        $db = $this->db;
        //$Identifica = $this->Identifica;
        $Usuario = $this->Usuario;
        $sql = "SELECT 
                    tb.tiempo_expiracion * 60 - (UNIX_TIMESTAMP() - UNIX_TIMESTAMP(bu.fecha))
                FROM
                    admin_bloqueo_usuario bu
                        JOIN
                    admin_tipo_bloqueo tb ON bu.tipo_bloqueo = tb.id
                WHERE
                    bu.usuario = '$Usuario'
                        AND bu.activo = 'SI'";

        $tiempo = $db->select_one($sql);
        if (intval($tiempo) > 0) {

            $r = array();
            $r['error'] = true;
            $r['msg'] = "Usuario bloqueado por " . $this->Seg2Texto($tiempo);
            echo json_encode($r);
            exit(0);
        }
    }

    protected function ExpirarBloqueos() {
        $db = $this->db;
        $Usuario = $this->Usuario;
        //$Identifica = $this->Identifica;
        $sql = "UPDATE admin_bloqueo_usuario bu
                        JOIN
                    admin_tipo_bloqueo tb ON bu.tipo_bloqueo = tb.id 
                SET 
                    bu.activo = 'NO',
                    bu._fecha_desbloqueo = NOW()
                WHERE
                   bu.usuario = '$Usuario'
                        AND bu.activo = 'SI'
                        AND ROUND((UNIX_TIMESTAMP() - UNIX_TIMESTAMP(bu.fecha)) / 60) >= tb.tiempo_expiracion";
        $db->query($sql);
    }

    protected function Seg2Texto($tiempo) {

        $segundos_minutos = 60;
        $segundos_horas = $segundos_minutos * 60;
        $segundos_dias = $segundos_horas * 24;

        $dias = intval($tiempo / $segundos_dias);
        $tiempo = $tiempo % $segundos_dias;  // $tiempo - $dias * $segundos_dias;

        $horas = intval($tiempo / $segundos_horas);
        $tiempo = $tiempo % $segundos_horas;

        $minutos = intval($tiempo / $segundos_minutos);
        $tiempo = $tiempo % $segundos_minutos;

        $segundos = $tiempo;

        if ($dias > 0) {
            $texto = "$dias día(s), $horas hora(s), $minutos mimuto(s), $segundos segundo(s)";
        } else if ($horas > 0) {
            $texto = "$horas hora(s), $minutos mimuto(s), $segundos segundo(s)";
        } else if ($minutos > 0) {
            $texto = "$minutos mimuto(s), $segundos segundo(s)";
        } else {
            $texto = "$segundos segundo(s)";
        }

        return $texto;
    }

}

$f = new Sesion();
$f->Ejecutar(ACCION);

