<?php

class Usuario {
    /* @var $db DbMySQL */

    protected $db;
    protected $RID;

    public function __construct() {
        /* @var $db DbMySQL */
        $this->db = $GLOBALS['db'];
        $this->RID = new RandId(MENU);
    }

    function Ejecutar($Accion) {
        switch ($Accion) {
            case "Listar":
                $this->Listar();
                break;

            case "agregar":
                $this->Agregar();
                break;

            case "asignar":
                $this->Asignar();
                break;

            case "listar":
                $this->Listar();
                break;

            case "modificar":
                $this->Modificar();
                break;

            case "eliminar":
                $this->Eliminar();
                break;

            case "listar-personas":
                $this->ListarPersonas();
                break;
        }
    }

    function Validar() {
        $v = new Validation($_POST);
        $v->addRules('identifica', 'Nombre', ['required' => true]);
        //$v->addRules('usuario', 'Usuario', ['required' => true, 'length' => [8, 20], 'regExp' => "/^[0-9a-zA-ZÑñ]*$/"]);
        $v->addRules('rol', 'Rol', ['required' => true]);


        $result = $v->validate();
        if ($result['messages'] == "") {//No hay errores de validacion
            return true;
        } else { //Errores de validación
            $r['error'] = true;
            $r['msg'] = $result['messages'];
            $r['bad_fields'] = $result['bad_fields'];
            $r['errors'] = $result['errors'];
            echo json_encode($r);
            exit(0);
        }
        return true;
    }

    protected function GetSQL() {

        $filtro = "";

        if (ACCION == "listar" && isset($_GET['filters']) && is_array($_GET['filters'])) {
            $f = $_GET['filters'];

            if (isset($f['usuario']) && $f['usuario'] !== "") {
                $q = str_replace(" ", "%", $f['usuario']);
                $filtro .= " AND p.usuario   LIKE '%$q%' ";
            }

            if (isset($f['identifica']) && $f['identifica'] !== "") {
                $q = str_replace(" ", "%", $f['identifica']);
                $filtro .= " AND p.identifica   LIKE '%$q%' ";
            }

            if (isset($f['nombre']) && $f['nombre'] !== "") {
                $q = str_replace(" ", "%", $f['nombre']);
                $filtro .= " AND  CONCAT_WS(' ', p.nombre1, p.nombre2, p.apellido1, p.apellido2) LIKE '%$q%' ";
            }

            if (isset($f['rol']) && $f['rol'] !== "") {
                $q = str_replace(" ", "%", $f['rol']);
                $filtro .= " AND  r.nombre   LIKE '%$q%' ";
            }
        }

        $sql = "SELECT 
                    u.id,
                    p.usuario,
                    p.identifica,
                    CONCAT_WS(' ', p.nombre1,p.nombre2, p.apellido1, p.apellido2) AS nombre,
                    r.nombre AS rol
                FROM
                    admin_usuario_rol u
                        JOIN
                    admin_rol r ON u.rol = r.id
                        JOIN
                    persona p ON u.identifica = p.identifica
                WHERE 1  $filtro
                ORDER BY nombre";

        return $sql;
    }

    protected function GetFila($Id = NULL) {
        $db = $this->db;
        $sql_base = $this->GetSQL();

        if ($Id == NULL) {
            $Id = $db->last_insert_id();
        }

        $sql = "SELECT * FROM ($sql_base) AS t WHERE id='$Id' ";
        $row = $db->select_row($sql);
        $row['id'] = $this->RID->GetRandId($Id);
        return $row;
    }

    function Listar() {
        $db = $this->db;
        $sql = $this->GetSQL();
        $result['total'] = $db->count_rows($sql);
        $offset = $_GET['offset'];
        $limit = $_GET['limit'];

        $rs = $db->select_limit($sql, $limit, $offset);
        $result['rows'] = [];
        $num = $offset + 1;
        while ($rw = $db->fetch_assoc($rs)) {
            $rw['id'] = $this->RID->GetRandId($rw['id']);
            $rw['_NUM_'] = $num++;
            $result['rows'][] = $rw;
        }
        echo json_encode($result);
    }

    function Agregar() {
        $db = $this->db;
        $this->validar();

        $row = [];
        $row['rol'] = $this->RID->GetValue($_POST['rol']);
        $row['identifica'] = $this->RID->GetValue($_POST['identifica']);
        $row['_usuario_creacion'] = $_SESSION['usuario'];
        $row['_fecha_creacion'] = date('Y-m-d H:i:s');

        $db->insert('admin_usuario_rol', $row);
        //
        $result = array();
        if ($db->error()) {
            $result['error'] = true;
            $result['msg'] = $db->error();
        } else {
            $result['error'] = false;
            $result['msg'] = "Registro agregado con éxito";
            $result['row'] = $this->GetFila();
        }
        echo json_encode($result);
    }

    function Asignar() {
        $db = $this->db;
        $RID = $this->RID;

        $Id = $RID->GetValue($_GET['id']);
        $sql = "SELECT 
                    u.id,
                    p.usuario,
                    p.identifica as persona_id,
                    CONCAT_WS('', p.nombre1,' ',p.nombre2,' ', p.apellido1,' ', p.apellido2, ' [',p.identifica,']') AS persona_nombre,
                    u.rol
                FROM
                    admin_usuario_rol u
                        JOIN
                    persona p ON u.identifica = p.identifica
                WHERE 
                    u.id ='$Id' ";
        $rw = $db->select_row($sql);
        $rw['id'] = $_GET['id'];
        $rw['identifica'] = ['value' => $RID->GetRandId($rw['persona_id']), 'text' => $rw['persona_nombre']];
        $rw['rol'] = $RID->GetRandId($rw['rol']);
        echo json_encode($rw);
    }

    function Modificar() {
        $db = $this->db;
        $this->validar();

        $Id = $this->RID->GetValue($_POST['id']);

        $row = [];
        $row['rol'] = $this->RID->GetValue($_POST['rol']);
        $row['_usuario_modificacion'] = $_SESSION['usuario'];
        $row['_fecha_modificacion'] = date('Y-m-d H:i:s');
        $sql = $db->make_update("admin_usuario_rol", $row) . " where id='$Id'";


        $db->query($sql);

        $r = array();
        if ($db->error()) {
            $r['error'] = true;
            $r['msg'] = $db->error();
        } else {
            $r['error'] = false;
            $r['msg'] = "Registro modificado con éxito.";
            $r['row'] = $this->GetFila($Id);
        }
        echo json_encode($r);
    }

    function Eliminar() {
        $db = $this->db;
        $Id = $this->RID->GetValue($_POST['id']);
        $sql = "delete from admin_usuario_rol where id='$Id'";
        $db->query($sql);

        $r = array();
        if ($db->error()) {
            $r['error'] = true;
            $r['msg'] = $db->error();
        } else {
            $r['error'] = false;
            $r['msg'] = "Registro eliminado con éxito.";
        }
        echo json_encode($r);
    }

    function ListarPersonas() {
        $db = $this->db;
        $query = $_GET['query'];
        $query = str_replace(" ", "%", $query);
        $sql = "SELECT
                    p.identifica as value,
                    CONCAT_WS('', p.nombre1,' ', p.nombre2,' ', p.apellido1,' ', p.apellido2, ' [',p.identifica,']') AS text
                FROM
                    persona p
                WHERE
                    CONCAT_WS('', p.nombre1,' ', p.nombre2,' ', p.apellido1,' ', p.apellido2, ' [',p.identifica,']') LIKE '%$query%'
                ORDER BY p.nombre1,p.nombre2
                LIMIT 50";
        $rs = $this->db->query($sql);
        $rows = [];
        while ($rw = $db->fetch_assoc($rs)) {
            $rw['value'] = $this->RID->GetRandId($rw['value']);
            $rows[] = $rw;
        }
        echo json_encode($rows);
    }

}

$f = new Usuario();
$f->Ejecutar(ACCION);
?>