<?php

class BloquePregunta
{
    /* @var $db $DbMySQL */
    protected $db;

    /* @var $RID RandId */
    protected $RID;

    public function __construct()
    {
        $this->db = $GLOBALS['db'];
        $this->RID = $GLOBALS['RID'];
    }

    function Ejecutar($Accion)
    {
        switch ($Accion) {
            case "Listar":
                $this->Listar();
                break;

            case "agregar":
                $this->Agregar();
                break;

            case "asignar":
                $this->Asignar();
                break;

            case "listar":
                $this->Listar();
                break;

            case "modificar":
                $this->Modificar();
                break;

            case "eliminar":
                $this->Eliminar();
                break;
        }
    }

    function Validar()
    {
        $v = new Validation($_POST);
        $v->AddRules('banco_pregunta', 'Banco pregunta', ['Required']);
        $v->AddRules('nombre', 'Nombre', ['Required', 'ValidText', 'MaxLength' => 200]);
        $v->AddRules('contenido', 'Contenido', ['Required']);

        $result = $v->Validate();
        if ($result['messages'] !== "") { //Hay errores de validación
            $r['error'] = true;
            $r['msg'] = $result['messages'];
            $r['bad_fields'] = $result['bad_fields'];
            $r['errors'] = $result['errors'];
            echo json_encode($r);
            exit(0);
        }
        return true;
    }

    protected function GetSQL()
    {
        $RID = $this->RID;
        $sql = "SELECT 
                    bp.id, b.nombre AS banco_pregunta, bp.nombre
                FROM
                    bloque_pregunta bp
                        JOIN
                    banco_pregunta b ON bp.banco_pregunta = b.id
                ORDER BY banco_pregunta , nombre";
        return $sql;
    }

    protected function Fila($Id = NULL)
    {
        $db = $this->db;
        $sql_base = $this->GetSQL();

        //Revisar
        if ($Id == NULL) {
            $Id = $db->last_insert_id();
        }

        $sql = "SELECT * FROM ($sql_base) AS t WHERE id='$Id' ";

        $row = $db->select_row($sql);
        $row['id'] = $this->RID->GetRandId($Id);
        return $row;
    }

    function Listar()
    {
        $db = $this->db;
        $RID = $this->RID;
        $sql = $this->getSQL();

        $Result = [];
        $Result['total'] = $db->count_rows($sql);

        $Offset = $_GET['offset'];
        $Limit = $_GET['limit'];

        $rs = $db->select_limit($sql, $Limit, $Offset);
        $Result['rows'] = array();
        $Num = $Offset + 1;
        while ($Row = $db->fetch_assoc($rs)) {
            $Row['_NUM_'] = $Num++;
            $Row['id'] = $RID->GetRandId($Row['id']);
            $Result['rows'][] = $Row;
        }
        echo json_encode($Result);
    }

    function Agregar()
    {
        $db = $this->db;
        $RID = $this->RID;

        $this->Validar();

        $Row = [];
        $Row['banco_pregunta'] = $RID->GetValue($_POST['banco_pregunta']);
        $Row['nombre'] = $_POST['nombre'];
        $Row['contenido'] = $_POST['contenido'];
        $Row['_usuario_creacion'] = $_SESSION['usuario'];
        $Row['_fecha_creacion'] = date('Y-m-d H:i:s');
        $db->insert('bloque_pregunta', $Row);
        //
        $result = array();
        if ($db->error()) {
            $result['error'] = true;
            $result['msg'] = $db->error();
        } else {
            $result['error'] = false;
            $result['msg'] = "Registro agregado con éxito";
            $result['row'] = $this->fila();
        }
        echo json_encode($result);
    }

    function Asignar()
    {
        $db = $this->db;
        $RID = $this->RID;
        $Id = $RID->GetValue($_GET['id']);

        $sql = "SELECT * FROM bloque_pregunta WHERE id='$Id'";
        $Row = $db->select_row($sql);
        $Row['id'] = $RID->GetRandId($Row['id']);
        $Row['banco_pregunta'] = $RID->GetRandId($Row['banco_pregunta']);

        echo json_encode($Row);
    }

    function Modificar()
    {
        $db = $this->db;
        $RID = $this->RID;

        $this->Validar();

        $Row = [];
        $Row['banco_pregunta'] = $RID->GetValue($_POST['banco_pregunta']);
        $Row['nombre'] = $_POST['nombre'];
        $Row['contenido'] = $_POST['contenido'];
        $Row['_usuario_modificacion'] = $_SESSION['usuario'];
        $Row['_fecha_modificacion'] = date('Y-m-d H:i:s');
        $Id = $this->RID->GetValue($_POST['id']);
        $sql = $db->make_update("bloque_pregunta", $Row) . " WHERE id='$Id'";
        $db->query($sql);

        $r = array();
        if ($db->error()) {
            $r['error'] = true;
            $r['msg'] = $db->error();
        } else {
            $r['error'] = false;
            $r['msg'] = "Registro modificado con éxito.";
            $r['row'] = $this->Fila($Id);
        }
        echo json_encode($r);
    }

    function Eliminar()
    {
        $db = $this->db;
        $Id = $this->RID->GetValue($_POST['id']);
        $sql = "DELETE FROM bloque_pregunta WHERE id='$Id'";
        $db->query($sql);

        $r = array();
        if ($db->error()) {
            $r['error'] = true;
            $r['msg'] = $db->error();
        } else {
            $r['error'] = false;
            $r['msg'] = "Registro eliminado con éxito.";
        }
        echo json_encode($r);
    }
}

$f = new BloquePregunta();
$f->Ejecutar(ACCION);
