<?php

class Pregunta {
    /* @var $db $DbMySQL */

    protected $db;

    /* @var $RID RandId */
    protected $RID;

    public function __construct() {
        $this->db = $GLOBALS['db'];
        $this->RID = $GLOBALS['RID'];
    }

    function Ejecutar($Accion) {
        switch ($Accion) {
            case "Listar":
                $this->Listar();
                break;

            case "agregar":
                $this->Agregar();
                break;

            case "asignar":
                $this->Asignar();
                break;

            case "listar":
                $this->Listar();
                break;

            case "modificar":
                $this->Modificar();
                break;

            case "eliminar":
                $this->Eliminar();
                break;

            case "listar-banco-pregunta":
                $this->ListarBancoPregunta();
                break;

            case "listar-competencia":
                $this->ListarCompetencia();
                break;
        }
    }

    function Validar() {
        $v = new Validation($_POST);
        $v->AddRules('banco_pregunta', 'Banco pregunta', ['Required']);
        $v->AddRules('nivel_dificultad', 'Nivel dificultad', ['Required']);
        $v->AddRules('competencia', 'Competencia', ['Required']);
        $v->AddRules('respuesta_correcta', 'Respuesta correcta', ['Required']);
        $v->AddRules('bloque_pregunta', 'Bloque pregunta', []);
        $v->AddRules('descripcion', 'Descripción', ['Required', 'MaxLength' => 100]);
        $v->AddRules('contenido', 'Contenido', ['Required']);
        $v->AddRules('justificacion', 'Justificación', ['MaxLength' => 500]);

        $result = $v->Validate();
        if ($result['messages'] !== "") { //Hay errores de validación
            $r['error'] = true;
            $r['msg'] = $result['messages'];
            $r['bad_fields'] = $result['bad_fields'];
            $r['errors'] = $result['errors'];
            echo json_encode($r);
            exit(0);
        }
        return true;
    }

    protected function GetSQL() {
        $RID = $this->RID;

        $filtros = "";

        if (ACCION == "listar") {

            if (isset($_GET['banco-pregunta']) && isset($_GET['banco-pregunta']) != "") {
                $banco_pregunta = $RID->GetValue($_GET['banco-pregunta']);
                $filtros .= " AND banco_pregunta = '$banco_pregunta' ";
            } else {
                $filtros .= " AND banco_pregunta = 'x' ";
            }

            if (isset($_GET['filters']) && is_array($_GET['filters'])) {


                $f = $_GET['filters'];

                if (isset($f['banco_pregunta']) && $f['banco_pregunta'] !== "") {
                    $q = $RID->GetValue($f['banco_pregunta']);
                    $filtros .= " AND banco_pregunta = '$q' ";
                }

                if (isset($f['competencia']) && $f['competencia'] !== "") {
                    $q = $RID->GetValue($f['competencia']);
                    $filtros .= " AND competencia = '$q' ";
                }

                if (isset($f['descripcion']) && $f['descripcion'] !== "") {
                    $q = str_replace(' ', '%', $f['descripcion']);
                    $filtros .= " AND descripcion LIKE '%$q%' ";
                }
            }
        }

        $sql = "SELECT 
                    p.id,
                    bp.nombre AS banco_pregunta,
                    c.nombre AS competencia,
                    p.descripcion
                FROM
                    pregunta p
                        JOIN
                    banco_pregunta bp ON p.banco_pregunta = bp.id
                        JOIN
                    competencia c ON p.competencia = c.id
                WHERE 1 $filtros
                ORDER BY banco_pregunta , competencia , descripcion";
        // echo $sql;
        return $sql;
    }

    protected function Fila($Id = NULL) {
        $db = $this->db;
        $sql_base = $this->GetSQL();

        //Revisar
        if ($Id == NULL) {
            $Id = $db->last_insert_id();
        }

        $sql = "SELECT * FROM ($sql_base) AS t WHERE id='$Id' ";

        $row = $db->select_row($sql);
        $row['id'] = $this->RID->GetRandId($Id);
        return $row;
    }

    function Listar() {
        $db = $this->db;
        $RID = $this->RID;
        $sql = $this->getSQL();

        $Result = [];
        $Result['total'] = $db->count_rows($sql);

        $Offset = $_GET['offset'];
        $Limit = $_GET['limit'];

        $rs = $db->select_limit($sql, $Limit, $Offset);
        $Result['rows'] = array();
        $Num = $Offset + 1;
        while ($Row = $db->fetch_assoc($rs)) {
            $Row['_NUM_'] = $Num++;
            $Row['id'] = $RID->GetRandId($Row['id']);
            $Result['rows'][] = $Row;
        }
        echo json_encode($Result);
    }

    function Agregar() {
        $db = $this->db;
        $RID = $this->RID;

        $this->Validar();

        $Row = [];
        $Row['banco_pregunta'] = $RID->GetValue($_POST['banco_pregunta']);
        $Row['nivel_dificultad'] = $RID->GetValue($_POST['nivel_dificultad']);
        $Row['competencia'] = $RID->GetValue($_POST['competencia']);
        $Row['respuesta_correcta'] = $_POST['respuesta_correcta'];
        $Row['bloque_pregunta'] = $RID->GetValue($_POST['bloque_pregunta']);
        $Row['descripcion'] = $_POST['descripcion'];
        $Row['contenido'] = $_POST['contenido'];
        $Row['justificacion'] = $_POST['justificacion'];

        $Row['_usuario_creacion'] = $_SESSION['usuario'];
        $Row['_fecha_creacion'] = date('Y-m-d H:i:s');
        $db->insert('pregunta', $Row);
        //
        $result = array();
        if ($db->error()) {
            $result['error'] = true;
            $result['msg'] = $db->error();
        } else {
            $result['error'] = false;
            $result['msg'] = "Registro agregado con éxito";
            $result['row'] = $this->fila();
        }
        echo json_encode($result);
    }

    function Asignar() {
        $db = $this->db;
        $RID = $this->RID;
        $Id = $RID->GetValue($_GET['id']);

        $sql = "SELECT * FROM pregunta WHERE id='$Id'";
        $Row = $db->select_row($sql);
        $Row['id'] = $RID->GetRandId($Row['id']);
        $Row['banco_pregunta'] = $RID->GetRandId($Row['banco_pregunta']);
        $Row['nivel_dificultad'] = $RID->GetRandId($Row['nivel_dificultad']);
        $Row['competencia'] = $RID->GetRandId($Row['competencia']);
        $Row['bloque_pregunta'] = $RID->GetRandId($Row['bloque_pregunta']);
        $Row['justificacion'] = $Row['justificacion'];
        echo json_encode($Row);
    }

    function Modificar() {
        $db = $this->db;
        $RID = $this->RID;

        $this->Validar();

        $Row = [];
        $Row['banco_pregunta'] = $RID->GetValue($_POST['banco_pregunta']);
        $Row['nivel_dificultad'] = $RID->GetValue($_POST['nivel_dificultad']);
        $Row['competencia'] = $RID->GetValue($_POST['competencia']);
        $Row['respuesta_correcta'] = $_POST['respuesta_correcta'];
        $Row['bloque_pregunta'] = $RID->GetValue($_POST['bloque_pregunta']);
        $Row['descripcion'] = $_POST['descripcion'];
        $Row['justificacion'] = $_POST['justificacion'];
        $Row['contenido'] = $_POST['contenido'];

        $Row['_usuario_modificacion'] = $_SESSION['usuario'];
        $Row['_fecha_modificacion'] = date('Y-m-d H:i:s');
        $Id = $this->RID->GetValue($_POST['id']);
        $sql = $db->make_update("pregunta", $Row) . " WHERE id='$Id'";
        $db->query($sql);

        $r = array();
        if ($db->error()) {
            $r['error'] = true;
            $r['msg'] = $db->error();
        } else {
            $r['error'] = false;
            $r['msg'] = "Registro modificado con éxito.";
            $r['row'] = $this->Fila($Id);
        }
        echo json_encode($r);
    }

    function Eliminar() {
        $db = $this->db;
        $Id = $this->RID->GetValue($_POST['id']);
        $sql = "DELETE FROM pregunta WHERE id='$Id'";
        $db->query($sql);

        $r = array();
        if ($db->error()) {
            $r['error'] = true;
            $r['msg'] = $db->error();
        } else {
            $r['error'] = false;
            $r['msg'] = "Registro eliminado con éxito.";
        }
        echo json_encode($r);
    }

    function ListarBancoPregunta() {
        $db = $this->db;
        $sql = "SELECT id AS value, nombre AS text FROM banco_pregunta ORDER BY nombre DESC";
        $data = [];
        $rs = $db->query($sql);
        while ($rw = $db->fetch_assoc($rs)) {
            $rw['value'] = $this->RID->GetRandId($rw['value']);
            $data[] = $rw;
        }
        echo json_encode($data);
    }

    function ListarCompetencia() {
        $db = $this->db;
        $sql = "SELECT id AS value, nombre AS text FROM competencia ORDER BY nombre DESC";
        $data = [];
        $rs = $db->query($sql);
        while ($rw = $db->fetch_assoc($rs)) {
            $rw['value'] = $this->RID->GetRandId($rw['value']);
            $data[] = $rw;
        }
        echo json_encode($data);
    }

}

$f = new Pregunta();
$f->Ejecutar(ACCION);
