<?php

class Departamento {
    /* @var $db $DbMySQL */
    protected $db;

    /* @var $RID RandId */
    protected $RID;

    public function __construct() {
        $this->db = $GLOBALS['db'];
        $this->RID = $GLOBALS['RID'];
    }

    function Ejecutar($Accion) {
        switch ($Accion) {
            case "Listar":
                $this->Listar();
                break;

            case "agregar":
                $this->Agregar();
                break;

            case "asignar":
                $this->Asignar();
                break;

            case "listar":
                $this->Listar();
                break;

            case "modificar":
                $this->Modificar();
                break;

            case "eliminar":
                $this->Eliminar();
                break;

		case "listar-pais":
			$this->ListarPais();
			break;

        }
    }

    function Validar() {
        $v = new Validation($_POST); 
		$v->AddRules('nombre', 'Nombre', ['Required', 'ValidText', 'MaxLength' => 35]);
		$v->AddRules('pais', 'País', ['Required']);
		$v->AddRules('codigo_divipola', 'Código', ['Required', 'ValidText', 'MaxLength' => 10]);

        $result = $v->Validate();
        if ($result['messages'] !== "") { //Hay errores de validación
            $r['error'] = true;
            $r['msg'] = $result['messages'];
            $r['bad_fields'] = $result['bad_fields'];
            $r['errors'] = $result['errors'];
            echo json_encode($r);
            exit(0);
        }
        return true;
    }

    protected function GetSQL() {
        $RID = $this->RID;


	$filtros = ""; 
	if (ACCION == "listar" && isset($_GET['filters']) && is_array($_GET['filters'])) {
	$f = $_GET['filters'];

	if (isset($f['nombre']) && $f['nombre'] !== "") {
		$q = str_replace(' ', '%', $f['nombre']);
		$filtros .= " AND nombre LIKE '%$q%' ";
	}

	if (isset($f['pais']) && $f['pais'] !== "") {
		$q = $RID->GetValue($f['pais']);		$filtros .= " AND pais = '$q' ";
	}

	if (isset($f['codigo_divipola']) && $f['codigo_divipola'] !== "") {
		$q = str_replace(' ', '%', $f['codigo_divipola']);
		$filtros .= " AND codigo_divipola LIKE '%$q%' ";
	}

	}

        $sql = "SELECT * FROM departamento WHERE 1 $filtros";
        return $sql;
    }

    protected function Fila($Id = NULL) {
        $db = $this->db;
        $sql_base = $this->GetSQL();

        //Revisar
        if ($Id == NULL) {
            $Id = $db->last_insert_id();
        }

        $sql = "SELECT * FROM ($sql_base) AS t WHERE id='$Id' ";

        $row = $db->select_row($sql);
        $row['id'] = $this->RID->GetRandId($Id);
        return $row;
    }

    function Listar() {
        $db = $this->db;
        $RID = $this->RID;
        $sql = $this->getSQL();

        $Result=[];
        $Result['total'] = $db->count_rows($sql);

        $Offset = $_GET['offset'];
        $Limit = $_GET['limit'];

        $rs = $db->select_limit($sql, $Limit, $Offset);
        $Result['rows'] = array();
        $Num = $Offset + 1;
        while ($Row = $db->fetch_assoc($rs)) {
            $Row['_NUM_'] = $Num++;
            $Row['id'] = $RID->GetRandId($Row['id']);
            $Result['rows'][] = $Row;
        }
        echo json_encode($Result);
    }

    function Agregar() {
        $db = $this->db;
        $RID = $this->RID;

        $this->Validar();

        $Row = [];
	$Row['nombre'] = $_POST['nombre'];
	$Row['pais'] = $RID->GetValue($_POST['pais']);
	$Row['codigo_divipola'] = $_POST['codigo_divipola'];
	$Row['_usuario_creacion'] = $_SESSION['usuario']; 
	$Row['_fecha_creacion'] = date('Y-m-d H:i:s');
        $db->insert('departamento', $Row);
        //
        $result = array();
        if ($db->error()) {
            $result['error'] = true;
            $result['msg'] = $db->error();
        } else {
            $result['error'] = false;
            $result['msg'] = "Registro agregado con éxito";
            $result['row'] = $this->fila();
        }
        echo json_encode($result);
    }

    function Asignar() {
        $db = $this->db;
        $RID = $this->RID;
        $Id = $RID->GetValue($_GET['id']);

        $sql = "SELECT * FROM departamento WHERE id='$Id'";
        $Row = $db->select_row($sql);
        $Row['id'] = $RID->GetRandId($Row['id']);
	$Row['pais'] = $RID->GetRandId($Row['pais']);

        echo json_encode($Row);
    }

    function Modificar() {
        $db = $this->db;
        $RID = $this->RID;

        $this->Validar();

        $Row = [];
	$Row['nombre'] = $_POST['nombre'];
	$Row['pais'] = $RID->GetValue($_POST['pais']);
	$Row['codigo_divipola'] = $_POST['codigo_divipola'];
	$Row['_usuario_modificacion'] = $_SESSION['usuario']; 
	$Row['_fecha_modificacion'] = date('Y-m-d H:i:s');
        $Id = $this->RID->GetValue($_POST['id']);
        $sql = $db->make_update("departamento", $Row) . " WHERE id='$Id'";
        $db->query($sql);

        $r = array();
        if ($db->error()) {
            $r['error'] = true;
            $r['msg'] = $db->error();
        } else {
            $r['error'] = false;
            $r['msg'] = "Registro modificado con éxito.";
            $r['row'] = $this->Fila($Id);
        }
        echo json_encode($r);
    }

    function Eliminar() {
        $db = $this->db;
        $Id = $this->RID->GetValue($_POST['id']);
        $sql = "DELETE FROM departamento WHERE id='$Id'";
        $db->query($sql);

        $r = array();
        if ($db->error()) {
            $r['error'] = true;
            $r['msg'] = $db->error();
        } else {
            $r['error'] = false;
            $r['msg'] = "Registro eliminado con éxito.";
        }
        echo json_encode($r);
    }

    function ListarPais() {
        $db = $this->db;
        $sql = "SELECT codigo AS value, nombre AS text FROM pais ORDER BY nombre DESC";
        $data = [];
        $rs = $db->query($sql);
        while ($rw = $db->fetch_assoc($rs)) {
            $rw['value'] = $this->RID->GetRandId($rw['value']);
            $data[] = $rw;
        }
        echo json_encode($data);
    }

}

$f = new Departamento();
$f->Ejecutar(ACCION);
?>
