<div id="div-grid">
    <div id="toolbar">
        <span>Departamentos</span>
        <button class="btn btn-sm btn-success btn-circle  float-right btn-agregar" title="Agregar"  >
            <i class="fa  fa-plus-circle "></i>  
        </button>
    </div>

    <table id="tabla" 
           data-toggle="table"
           data-toolbar="#toolbar"
           data-pagination="true"
           data-side-pagination="server"
           data-page-size="50"
           data-page-list="[]"
           data-unique-id="id"
           data-url ="<?php echo PAGE_PATH . "listar" ?>"
           data-search="false"
           data-height="300"
           data-row-style="setRowStyle"
           data-mobile-responsive="true">
        <thead>
            <tr>
                <th data-field="_NUM_" data-width="60px">No</th>     
                <th data-field="nombre" data-width="" data-filter-type="text">Nombre</th>
                <th data-field="pais" data-width="200" data-filter-type="select" 
                    data-filter-source="<?php echo PAGE_PATH . "listar-pais" ?>">País</th>
                <th data-field="codigo_divipola" data-width="200" data-filter-type="text">Código</th>

                <th data-field="acciones" data-formatter="operateFormatter"  
                    data-events="operateEvents" 
                    data-align="center"
                    data-width="80px"
                    >Acciones</th>
            </tr>
        </thead>
    </table>
</div>

<div id="div-formulario" class="mb-3">
    <div class="card card-custom card-700">
        <div class="card-header px-3 py-1">
            <span id="titulo-accion" style="font-size: inherit">Agregar</span>
            departamento
        </div>
        <div class="card-body">
            <form class="form-horizontal" id="formulario" data-toggle="validator" role="form">
                <input id="id" name="id" type="hidden"/>


                <div class="form-group row">
                    <label class="control-label col-sm-2" for="nombre">Nombre</label>
                    <div class="col-sm-10">
                        <input type="text" id="nombre" name="nombre" class="form-control form-control-sm" maxlength="35" placeholder="Nombre" required data-valid-text/>
                        <div class="help-block with-errors"></div>
                    </div>
                </div>
                <div class="form-group row">
                    <label class="control-label col-sm-2" for="pais">País</label>
                    <div class="col-sm-10">
                        <select name="pais" id="pais" class="form-control form-control-sm" required>
                            <option value="">(Seleccionar país)</option>
                            <?php
                            llenar_combo("SELECT codigo, nombre FROM pais ORDER BY nombre LIMIT 1000");
                            ?>
                        </select>
                        <div class="help-block with-errors"></div>
                    </div> 
                </div>
                <div class="form-group row">
                    <label class="control-label col-sm-2" for="codigo_divipola">Código</label>
                    <div class="col-sm-10">
                        <input type="text" id="codigo_divipola" name="codigo_divipola" class="form-control form-control-sm" maxlength="10" placeholder="Codigo divipola" required data-valid-text/>
                        <div class="help-block with-errors"></div>
                    </div>
                </div>


                <div class="form-group row mb-0">
                    <div class="col-sm-10 offset-sm-2">
                        <input type="button" class="btn   btn-sm btn-success btn-aceptar" value="Guardar">
                        <input type="button" class="btn   btn-sm  btn-secondary btn-regresar" value="Regresar">
                    </div>
                </div>
                <div class="working no-show"></div>
            </form>
        </div>
    </div>
</div>

<script type="text/javascript">
    var f = new Formulario();
</script>