<div id="div-grid">
    <div id="toolbar">
        <span>Municipios</span>
        <button class="btn btn-sm btn-success btn-circle  float-right btn-agregar" title="Agregar"  >
            <i class="fa  fa-plus-circle "></i>  
        </button>
    </div>

    <table id="tabla" 
           data-toggle="table"
           data-toolbar="#toolbar"
           data-pagination="true"
           data-side-pagination="server"
           data-page-size="50"
           data-page-list="[]"
           data-unique-id="id"
           data-url ="<?php echo PAGE_PATH . "listar" ?>"
           data-search="false"
           data-height="300"
           data-row-style="setRowStyle"
           data-mobile-responsive="true">
        <thead>
            <tr>
                <th data-field="_NUM_" data-width="60px">No</th>     
		<th data-field="nombre" data-width="" data-filter-type="text">Nombre</th>
		<th data-field="codigo_divipola" data-width="200" data-filter-type="text">Codigo divipola</th>

                <th data-field="acciones" data-formatter="operateFormatter"  
                    data-events="operateEvents" 
                    data-align="center"
                    data-width="80px"
                    >Acciones</th>
            </tr>
        </thead>
    </table>
</div>

<div id="div-formulario" class="mb-3">
    <div class="card card-custom card-1000">
        <div class="card-header px-3 py-1">
            <span id="titulo-accion" style="font-size: inherit">Agregar</span>
            Municipio
        </div>
        <div class="card-body">
            <form  id="formulario" data-toggle="validator" role="form">
                <input id="id" name="id" type="hidden"/>


                <div class="form-group">
                    <label class="control-label" for="nombre">Nombre</label>
                    <input type="text" id="nombre" name="nombre" class="form-control form-control-sm" maxlength="60" placeholder="Nombre" required data-valid-text/>
                    <div class="help-block with-errors"></div>
                </div>
                <div class="form-group">
                    <label class="control-label" for="departamento">Departamento</label>
                    <select name="departamento" id="departamento" class="form-control form-control-sm" required>
                        <option value="">(Seleccionar departamento)</option>
                        <?php
                        llenar_combo("SELECT id, nombre FROM departamento ORDER BY nombre LIMIT 1000");
                        ?>
                    </select>
                    <div class="help-block with-errors"></div>
                </div>
                <div class="form-group">
                    <label class="control-label" for="codigo_divipola">Codigo divipola</label>
                    <input type="text" id="codigo_divipola" name="codigo_divipola" class="form-control form-control-sm" maxlength="10" placeholder="Codigo divipola" required data-valid-text/>
                    <div class="help-block with-errors"></div>
                </div>


                <div class="form-group form-btns-actions-right mb-0">
                    <input type="button" class="btn btn-sm btn-success btn-aceptar" value="Guardar">
                    <input type="button" class="btn btn-sm btn-secondary btn-regresar" value="Regresar">
                </div>
                
                <div class="working no-show"></div>
            </form>
        </div>
    </div>
</div>

<script type="text/javascript">
    var f = new Formulario();
</script>