<?php

class Persona {
    /* @var $db $DbMySQL */

    protected $db;

    /* @var $RID RandId */
    protected $RID;

    public function __construct() {
        $this->db = $GLOBALS['db'];
        $this->RID = $GLOBALS['RID'];
    }

    function Ejecutar($Accion) {
        switch ($Accion) {
            case "Listar":
                $this->Listar();
                break;

            case "agregar":
                $this->Agregar();
                break;

            case "asignar":
                $this->Asignar();
                break;

            case "listar":
                $this->Listar();
                break;

            case "modificar":
                $this->Modificar();
                break;

            case "eliminar":
                $this->Eliminar();
                break;
        }
    }

    function Validar() {
        $v = new Validation($_POST);

        $v->AddRules('tipo_identificacion_id', 'Tipo identificación', ['Required']);
        $v->AddRules('identifica', 'identificación', ['Required', 'ValidText', 'MaxLength' => 15]);
        //$v->AddRules('usuario', 'Usuario', ['Required', 'ValidText', 'MaxLength' => 40]);
        $v->AddRules('nombre', 'Nombre', ['Required', 'ValidText', 'MaxLength' => 120]);
        $v->AddRules('apellido', 'Apellido', ['ValidText', 'MaxLength' => 120]);
        $v->AddRules('correo_principal', 'Correo principal', ['Required', 'MaxLength' => 60]);
        $v->AddRules('correo_alternativo', 'Correo alternativo', ['ValidText', 'MaxLength' => 60]);
        $v->AddRules('telefono_principal', 'Telefono principal', ['Required', 'ValidText', 'MaxLength' => 20]);
        $v->AddRules('telefono_alternativo', 'Telefono alternativo', ['ValidText', 'MaxLength' => 20]);
        $v->AddRules('municipio_residencia_id', 'Municipio residencia', ['Required']);
        $v->AddRules('direccion', 'Dirección', ['Required', 'MaxLength' => 80]);
        //$v->AddRules('clave', 'Clave', ['Required', 'ValidText', 'MaxLength' => 256]);

        $result = $v->Validate();
        if ($result['messages'] !== "") { //Hay errores de validación
            $r['error'] = true;
            $r['msg'] = $result['messages'];
            $r['bad_fields'] = $result['bad_fields'];
            $r['errors'] = $result['errors'];
            echo json_encode($r);
            exit(0);
        }
        return true;
    }

    protected function GetSQL() {
        $RID = $this->RID;
        $sql = "SELECT 
                    p.id,
                    t.codigo AS tipo_identificacion,
                    p.identifica,
                    CONCAT_WS(' ', p.nombre, p.apellido) AS nombre,
                    m.nombre AS municipio
                FROM
                    persona p
                        JOIN
                    tipo_identificacion t ON p.tipo_identificacion_id = t.id
                        JOIN
                    municipio m ON p.municipio_residencia_id = m.id
                ORDER BY nombre ";
        return $sql;
    }

    protected function Fila($Id = NULL) {
        $db = $this->db;
        $sql_base = $this->GetSQL();

        //Revisar
        if ($Id == NULL) {
            $Id = $db->last_insert_id();
        }

        $sql = "SELECT * FROM ($sql_base) AS t WHERE id='$Id' ";

        $row = $db->select_row($sql);
        $row['id'] = $this->RID->GetRandId($Id);
        return $row;
    }

    function Listar() {
        $db = $this->db;
        $RID = $this->RID;
        $sql = $this->getSQL();

        $Result = [];
        $Result['total'] = $db->count_rows($sql);

        $Offset = $_GET['offset'];
        $Limit = $_GET['limit'];

        $rs = $db->select_limit($sql, $Limit, $Offset);
        $Result['rows'] = array();
        $Num = $Offset + 1;
        while ($Row = $db->fetch_assoc($rs)) {
            $Row['_NUM_'] = $Num++;
            $Row['id'] = $RID->GetRandId($Row['id']);
            $Result['rows'][] = $Row;
        }
        echo json_encode($Result);
    }

    function Agregar() {
        $db = $this->db;
        $RID = $this->RID;

        $this->Validar();

        $Row = [];
      
        $Row['tipo_identificacion_id'] = $RID->GetValue($_POST['tipo_identificacion_id']);
        $Row['identifica'] = $_POST['identifica'];
        $Row['nombre'] = $_POST['nombre'];
        $Row['apellido'] = $_POST['apellido'];
        $Row['correo_principal'] = $_POST['correo_principal'];
        $Row['correo_alternativo'] = $_POST['correo_alternativo']; 
        $Row['telefono_principal'] = $_POST['telefono_principal'];
        $Row['telefono_alternativo'] = $_POST['telefono_alternativo'];
        $Row['municipio_residencia_id'] = $RID->GetValue($_POST['municipio_residencia_id']);
        $Row['direccion'] = $_POST['direccion'];

        $Row['clave'] = password_hash($_POST['identifica'], PASSWORD_DEFAULT);

        $Row['_usuario_creacion'] = $_SESSION['usuario'];
        $Row['_fecha_creacion'] = date('Y-m-d H:i:s');
        $db->insert('persona', $Row);
        //
        $result = array();
        if ($db->error()) {
            $result['error'] = true;
            $result['msg'] = $db->error();
        } else {
            $result['error'] = false;
            $result['msg'] = "Registro agregado con éxito";
            $result['row'] = $this->fila();
        }
        echo json_encode($result);
    }

    function Asignar() {
        $db = $this->db;
        $RID = $this->RID;
        $Id = $RID->GetValue($_GET['id']);

        $sql = "SELECT * FROM persona WHERE id='$Id'";
        $Row = $db->select_row($sql);
        $Row['id'] = $RID->GetRandId($Row['id']);
        $Row['tipo_identificacion_id'] = $RID->GetRandId($Row['tipo_identificacion_id']);
        $Row['municipio_residencia_id'] = $RID->GetRandId($Row['municipio_residencia_id']);

        echo json_encode($Row);
    }

    function Modificar() {
        $db = $this->db;
        $RID = $this->RID;

        $this->Validar();

        $Row = [];
        $Row['nombre'] = $_POST['nombre'];
        $Row['apellido'] = $_POST['apellido'];
        $Row['correo_principal'] = $_POST['correo_principal'];
        $Row['correo_alternativo'] = $_POST['correo_alternativo']; 
        $Row['telefono_principal'] = $_POST['telefono_principal'];
        $Row['telefono_alternativo'] = $_POST['telefono_alternativo'];
        $Row['municipio_residencia_id'] = $RID->GetValue($_POST['municipio_residencia_id']);
        $Row['direccion'] = $_POST['direccion'];
        $Row['_usuario_modificacion'] = $_SESSION['usuario'];
        $Row['_fecha_modificacion'] = date('Y-m-d H:i:s');
        $Id = $this->RID->GetValue($_POST['id']);
        $sql = $db->make_update("persona", $Row) . " WHERE id='$Id'";
        $db->query($sql);

        $r = array();
        if ($db->error()) {
            $r['error'] = true;
            $r['msg'] = $db->error();
        } else {
            $r['error'] = false;
            $r['msg'] = "Registro modificado con éxito.";
            $r['row'] = $this->Fila($Id);
        }
        echo json_encode($r);
    }

    function Eliminar() {
        $db = $this->db;
        $Id = $this->RID->GetValue($_POST['id']);
        $sql = "DELETE FROM persona WHERE id='$Id'";
        $db->query($sql);

        $r = array();
        if ($db->error()) {
            $r['error'] = true;
            $r['msg'] = $db->error();
        } else {
            $r['error'] = false;
            $r['msg'] = "Registro eliminado con éxito.";
        }
        echo json_encode($r);
    }

}

$f = new Persona();
$f->Ejecutar(ACCION);
?>
