<?php
$sql_mupio = "SELECT 
                    m.id, CONCAT_WS('', m.nombre, ' (', d.nombre, ')') AS nombre
                FROM
                    municipio m,
                    departamento d
                WHERE
                    m.departamento = d.id AND d.id='27'
                ORDER BY nombre";
?>

<div id="div-grid">
    <div id="toolbar">
        <span>Personas</span>
        <button class="btn btn-sm btn-success btn-circle  float-right btn-agregar" title="Agregar"  >
            <i class="fa fa-plus-circle"></i>  
        </button>
    </div>

    <table id="tabla" 
           data-toggle="table"
           data-toolbar="#toolbar"
           data-pagination="true"
           data-side-pagination="server"
           data-page-size="50"
           data-page-list="[]"
           data-unique-id="id"
           data-url ="<?php echo PAGE_PATH . "listar" ?>"
           data-search="false"
           data-height="300"
           data-row-style="setRowStyle"
           data-mobile-responsive="true">
        <thead>
            <tr>
                <th data-field="_NUM_" data-width="60px">No</th> 
                <th data-field="identifica" data-width="100">identificación</th>
                <th data-field="nombre" data-width="">Nombre</th>
                <th data-field="municipio" data-width="200">Municipio</th>
                
                <th data-field="acciones" data-formatter="operateFormatter"  
                    data-events="operateEvents" 
                    data-align="center"
                    data-width="80px"
                    >Acciones</th>
            </tr>
        </thead>
    </table>
</div>

<div id="div-formulario" class="mb-3">
    <div class="card card-custom card-800">
        <div class="card-header px-3 py-1">
            <span id="titulo-accion" style="font-size: inherit">Agregar</span>
            persona
        </div>
        <div class="card-body">
            <form class="form-horizontal" id="formulario" data-toggle="validator" role="form">
                <input id="id" name="id" type="hidden"/>

                <div class="form-group row">
                    <label class="control-label col-sm-3" for="tipo_identifica">Tipo identificación</label>
                    <div class="col-sm-9">
                        <select name="tipo_identificacion_id" id="tipo_identificacion_id" class="form-control form-control-sm no-modificable" required>
                            <option value="">(Seleccionar tipo identificación)</option>
                            <?php
                            llenar_combo("SELECT id, nombre FROM tipo_identificacion ORDER BY nombre LIMIT 1000");
                            ?>
                        </select>
                        <div class="help-block with-errors"></div>
                    </div> 
                </div>
 

                <div class="form-group row">
                <label class="control-label col-sm-3" for="identifica">identificación</label>
                    <div class="col-sm-9">
                        <input type="text" id="identifica" name="identifica" class="form-control form-control-sm no-modificable" maxlength="15" placeholder="identificación" required data-valid-text/>
                        <div class="help-block with-errors"></div>
                    </div>
                </div>
   
                <div class="form-group row">
                    <label class="control-label col-sm-3" for="nombre">Nombre / razón social</label>
                    <div class="col-sm-9">
                        <input type="text" id="nombre" name="nombre" class="form-control form-control-sm" 
                            maxlength="80" 
                            placeholder="Nombre"/>
                        <div class="help-block with-errors"></div>
                    </div>
                </div>

                <div class="form-group row">
                    <label class="control-label col-sm-3" for="apellido">Apellidos</label>
                    <div class="col-sm-9">
                        <input type="text" id="apellido" name="apellido" class="form-control form-control-sm"
                            maxlength="80" placeholder="Apellidos" required data-valid-text/>
                        <div class="help-block with-errors"></div>
                    </div>
                </div>
   
 
                <div class="form-group row">
                    <label class="control-label col-sm-3" for="correo_principal">Correo principal</label>
                    <div class="col-sm-9">
                        <input type="text" id="correo_principal" name="correo_principal" class="form-control form-control-sm" maxlength="60" placeholder="Correo principal" required />
                        <div class="help-block with-errors"></div>
                    </div>
                </div>

                <div class="form-group row">
                    <label class="control-label col-sm-3" for="correo_alternativo">Correo alternativo</label>
                    <div class="col-sm-9">
                        <input type="text" id="correo_alternativo" name="correo_alternativo" class="form-control form-control-sm" maxlength="60" placeholder="Correo alternativo" data-valid-text/>
                        <div class="help-block with-errors"></div>
                    </div>
 
                </div>
 
                <div class="form-group row">
                    <label class="control-label col-sm-3" for="telefono_principal">Telefono principal</label>
                    <div class="col-sm-9">
                        <input type="text" id="telefono_principal" name="telefono_principal" class="form-control form-control-sm" maxlength="20" placeholder="Telefono principal" required data-valid-text/>
                        <div class="help-block with-errors"></div>
                    </div>
                </div>

                <div class="form-group row">
                    <label class="control-label col-sm-3" for="telefono_alternativo">Telefono alternativo</label>
                    <div class="col-sm-9">
                        <input type="text" id="telefono_alternativo" name="telefono_alternativo" class="form-control form-control-sm" maxlength="20" placeholder="Telefono alternativo" data-valid-text/>
                        <div class="help-block with-errors"></div>
                    </div>
                </div>

                <div class="form-group row">
                    <label class="control-label col-sm-3" for="municipio_residencia">Municipio residencia</label>
                    <div class="col-sm-9">
                        <select name="municipio_residencia_id" id="municipio_residencia_id" class="form-control form-control-sm" required>
                            <option value="">(Seleccionar municipio residencia)</option>
                            <?php
                            llenar_combo($sql_mupio);
                            ?>
                        </select>
                        <div class="help-block with-errors"></div>
                    </div>
                </div>


                <div class="form-group row">
                <label class="control-label col-sm-3" for="direccion">Dirección</label>
                    <div class="col-sm-9">
                        <input type="text" id="direccion" name="direccion" class="form-control form-control-sm" maxlength="80" placeholder="Dirección" required data-valid-text/>
                        <div class="help-block with-errors"></div>
                    </div>
                </div>
 

                <div class="form-group row mb-0">
                    <div class="col-sm-9 offset-sm-3">
                        <input type="button" class="btn   btn-sm btn-success btn-aceptar" value="Guardar">
                        <input type="button" class="btn   btn-sm  btn-secondary btn-regresar" value="Regresar">
                    </div>
                </div>
                <div class="working no-show"></div>
            </form>
        </div>
    </div>
</div>

<script type="text/javascript">
    var f = new Formulario();
</script>