<div id="div-grid">
    <div id="toolbar">
        <span>Programas</span>
        <button class="btn btn-sm btn-success btn-circle  float-right btn-agregar" title="Agregar">
            <i class="fa  fa-plus-circle "></i>
        </button>
    </div>

    <table id="tabla" data-toggle="table" data-toolbar="#toolbar" data-pagination="true" data-side-pagination="server" data-page-size="50" data-page-list="[]" data-unique-id="id" data-url="<?php echo PAGE_PATH . "listar" ?>" data-search="false" data-height="300" data-row-style="setRowStyle" data-mobile-responsive="true">
        <thead>
            <tr>
                <th data-field="_NUM_" data-width="60px">No</th>
                <th data-field="nombre" data-width="500" data-filter-type="text">Nombre</th>
                <th data-field="facultad" data-width="500" data-filter-type="select" data-filter-source="<?php echo PAGE_PATH . "listar-facultad" ?>">Facultad</th>
                <th data-field="acciones" data-formatter="operateFormatter" data-events="operateEvents" data-align="center" data-width="80px">Acciones</th>
            </tr>
        </thead>
    </table>
</div>

<div id="div-formulario" class="mb-3">
    <div class="card card-custom card-600">
        <div class="card-header px-3 py-1">
            <span id="titulo-accion" style="font-size: inherit">Agregar</span>
            Programa
        </div>
        <div class="card-body">
            <form class="form-horizontal" id="formulario" data-toggle="validator" role="form">
                <input id="id" name="id" type="hidden" />


                <div class="form-group row">
                    <label class="control-label col-sm-2" for="facultad">Facultad</label>
                    <div class="col-sm-10">
                        <select name="facultad" id="facultad" class="form-control form-control-sm" required>
                            <option value="">(Seleccionar Facultad)</option>
                            <?php
                            llenar_combo("SELECT id, nombre FROM facultad ORDER BY nombre LIMIT 1000");
                            ?>
                        </select>
                        <div class="help-block with-errors"></div>
                    </div>
                </div>
                <div class="form-group row">
                    <label class="control-label col-sm-2" for="nombre">Nombre</label>
                    <div class="col-sm-10">
                        <input type="text" id="nombre" name="nombre" class="form-control form-control-sm" maxlength="100" placeholder="Nombre" required data-valid-text />
                        <div class="help-block with-errors"></div>
                    </div>
                </div>


                <div class="form-group row mb-0">
                    <div class="col-sm-10 offset-sm-2">
                        <input type="button" class="btn   btn-sm btn-success btn-aceptar" value="Guardar">
                        <input type="button" class="btn   btn-sm  btn-secondary btn-regresar" value="Regresar">
                    </div>
                </div>
                <div class="working no-show"></div>
            </form>
        </div>
    </div>
</div>

<script type="text/javascript">
    var f = new Formulario();
</script>