<?php

class BancoPregunta {
    /* @var $db $DbMySQL */
    protected $db;

    /* @var $RID RandId */
    protected $RID;

    public function __construct() {
        $this->db = $GLOBALS['db'];
        $this->RID = $GLOBALS['RID'];
    }

    function Ejecutar($Accion) {
        switch ($Accion) {
            case "Listar":
                $this->Listar();
                break;

            case "agregar":
                $this->Agregar();
                break;

            case "asignar":
                $this->Asignar();
                break;

            case "listar":
                $this->Listar();
                break;

            case "modificar":
                $this->Modificar();
                break;

            case "eliminar":
                $this->Eliminar();
                break;

        }
    }

    function Validar() {
        $v = new Validation($_POST); 
		$v->AddRules('nombre', 'Nombre', ['Required', 'MaxLength' => 250]);

        $result = $v->Validate();
        if ($result['messages'] !== "") { //Hay errores de validación
            $r['error'] = true;
            $r['msg'] = $result['messages'];
            $r['bad_fields'] = $result['bad_fields'];
            $r['errors'] = $result['errors'];
            echo json_encode($r);
            exit(0);
        }
        return true;
    }

    protected function GetSQL() {
        $RID = $this->RID;
        
        $filtros = "";

        if(ACCION == "listar") {
            $catagoria = $RID->GetValue( $_GET['categoria_id']);
            $filtros = " AND categoria_id ='$catagoria' ";
        }

        $sql = "SELECT * FROM respuesta WHERE 1 $filtros";
        return $sql;
    }

    protected function Fila($Id = NULL) {
        $db = $this->db;
        $sql_base = $this->GetSQL();

        //Revisar
        if ($Id == NULL) {
            $Id = $db->last_insert_id();
        }

        $sql = "SELECT * FROM ($sql_base) AS t WHERE id='$Id' ";

        $row = $db->select_row($sql);
        $row['id'] = $this->RID->GetRandId($Id);
        return $row;
    }

    function Listar() {
        $db = $this->db;
        $RID = $this->RID;
        $sql = $this->GetSQL();

        $Result=[];
        $Result['total'] = $db->count_rows($sql);

        $Offset = $_GET['offset'];
        $Limit = $_GET['limit'];

        $rs = $db->select_limit($sql, $Limit, $Offset);
        $Result['rows'] = array();
        $Num = $Offset + 1;
        while ($Row = $db->fetch_assoc($rs)) {
            $Row['_NUM_'] = $Num++;
            $Row['id'] = $RID->GetRandId($Row['id']);
            $Result['rows'][] = $Row;
        }
        echo json_encode($Result);
    }

    function Agregar() {
        $db = $this->db;
        $RID = $this->RID;

        $this->Validar();

        $Row = [];
        $Row['categoria_id'] = $RID->GetValue($_POST['categoria_id']);
        $Row['orden'] = $_POST['orden'];
        $Row['nombre'] = $_POST['nombre'];
        $Row['_usuario_creacion'] = $_SESSION['usuario']; 
        $Row['_fecha_creacion'] = date('Y-m-d H:i:s');
        $db->insert('respuesta', $Row);
        //
        
        $Id = $db->last_insert_id();
        

        if(isset($_POST['trl']) && is_array($_POST['trl']))
        {
            foreach ($_POST['trl'] as $trl)
            {
                $Row2 = [];
                $Row2['respuesta_id'] = $Id;
                $Row2['trl'] = $trl;    
                $db->insert('respuesta_trl', $Row2);
            }
        }



        if(isset($_POST['brl']) && is_array($_POST['brl']))
        {
            foreach ($_POST['brl'] as $brl)
            {
                $Row2 = [];
                $Row2['respuesta_id'] = $Id;
                $Row2['brl'] = $brl;    
                $db->insert('respuesta_brl', $Row2);
            }
        }    
        
        
        
        
        
        
        
        $result = array();
        if ($db->error()) {
            $result['error'] = true;
            $result['msg'] = $db->error();
        } else {
            $result['error'] = false;
            $result['msg'] = "Registro agregado con éxito";
            $result['row'] = $this->fila($Id);
        }
        echo json_encode($result);
    }

    function Asignar() {
        $db = $this->db;
        $RID = $this->RID;
        $Id = $RID->GetValue($_GET['id']);

        $sql = "SELECT * FROM respuesta WHERE id='$Id'";
        $Row = $db->select_row($sql);
        $Row['id'] = $RID->GetRandId($Row['id']);
        $Row['categoria_id'] = $RID->GetRandId($Row['categoria_id']);

        $sql = "SELECT * FROM respuesta_trl WHERE respuesta_id='$Id'";
        $rs = $db->query($sql);
        while ($rw = $db->fetch_assoc($rs)) 
        {
            $codigo = $rw['trl'];
            $Row['"trl[' . $codigo . ']"']=[$codigo];
        }
     
        $sql = "SELECT * FROM respuesta_brl WHERE respuesta_id='$Id'";
        $rs = $db->query($sql);
        while ($rw = $db->fetch_assoc($rs)) 
        {
            $codigo = $rw['brl'];
            $Row['"brl[' . $codigo . ']"']=[$codigo];
        }        
        echo json_encode($Row);
    }

    function Modificar() {
        $db = $this->db;
        $RID = $this->RID;

        $this->Validar();

        $Row = [];
        
        $Row['orden'] = $_POST['orden'];
        $Row['nombre'] = $_POST['nombre'];
        $Row['_usuario_modificacion'] = $_SESSION['usuario']; 
        $Row['_fecha_modificacion'] = date('Y-m-d H:i:s');
        $Id = $this->RID->GetValue($_POST['id']);
        $sql = $db->make_update("respuesta", $Row) . " WHERE id='$Id'";
        $db->query($sql);

        $db->query("DELETE FROM respuesta_trl WHERE respuesta_id ='$Id' ");

        if(isset($_POST['trl']) && is_array($_POST['trl']))
        {
            foreach ($_POST['trl'] as $trl)
            {
                $Row2 = [];
                $Row2['respuesta_id'] = $Id;
                $Row2['trl'] = $trl;    
                $db->insert('respuesta_trl', $Row2);
            }
        }



        $db->query("DELETE FROM respuesta_brl WHERE respuesta_id ='$Id' ");

        if(isset($_POST['brl']) && is_array($_POST['brl']))
        {
            foreach ($_POST['brl'] as $brl)
            {
                $Row2 = [];
                $Row2['respuesta_id'] = $Id;
                $Row2['brl'] = $brl;    
                $db->insert('respuesta_brl', $Row2);
            }
        }


        $r = array();
        if ($db->error()) {
            $r['error'] = true;
            $r['msg'] = $db->error();
        } else {
            $r['error'] = false;
            $r['msg'] = "Registro modificado con éxito.";
            $r['row'] = $this->Fila($Id);
        }
        echo json_encode($r);
    }

    function Eliminar() {
        $db = $this->db;
        $Id = $this->RID->GetValue($_POST['id']);
        $sql = "DELETE FROM respuesta WHERE id='$Id'";
        $db->query($sql);

        $r = array();
        if ($db->error()) {
            $r['error'] = true;
            $r['msg'] = $db->error();
        } else {
            $r['error'] = false;
            $r['msg'] = "Registro eliminado con éxito.";
        }
        echo json_encode($r);
    }

}

$f = new BancoPregunta();
$f->Ejecutar(ACCION);
?>
