<div id="div-grid">
    <div id="toolbar">
        <span>Opciones de respuestas</span>
        <button class="btn btn-sm btn-success btn-circle  float-right btn-agregar" title="Agregar"  >
            <i class="fa  fa-plus-circle "></i>  
        </button>

        <form class="filtros" >
            <div class="form-group form-group-sm col-md-12">
                <select id="f-categoria" name="categoria_id" class="form-control form-control-sm" >
                    <option value="">(Seleccionar categoría)</option>
                    <?php
                    llenar_combo("SELECT id, nombre FROM categoria ORDER BY nombre LIMIT 1000");
                    ?>        
                </select>
 
            </div>
        </form>

    </div>

    <table id="tabla" 
           data-toggle="table"
           data-toolbar="#toolbar"
           data-pagination="true"
           data-side-pagination="server"
           data-page-size="50"
           data-page-list="[]"
           data-unique-id="id"
           data-url ="<?php echo PAGE_PATH . "listar" ?>"
           data-search="false"
           data-height="300"
           data-row-style="setRowStyle"
           data-mobile-responsive="true">
        <thead>
            <tr>
                <th data-field="_NUM_" data-width="60px">No</th>     
                <th data-field="orden" data-width="80px">Orden</th>
		        <th data-field="nombre" data-width="">Nombre</th>
                <th data-field="acciones" data-formatter="operateFormatter"  
                    data-events="operateEvents" 
                    data-align="center"
                    data-width="80px"
                    >Acciones</th>
            </tr>
        </thead>
    </table>
</div>

<div id="div-formulario" class="mb-3">
    <div class="card card-custom card-800">
        <div class="card-header px-3 py-1">
            <span id="titulo-accion" style="font-size: inherit">Agregar</span>
            categorias
        </div>
        <div class="card-body">
            <form  id="formulario" data-toggle="validator" role="form">
                <input id="id" name="id" type="hidden"/>

                <div class="form-group row">
                    <label class="control-label col-sm-2" for="categoria_id">Categoría</label>
                    <div class="col-sm-10">
                        <select id="categoria_id" name="categoria_id" 
                            class="form-control form-control-sm no-modificable" >
                            <option value="">(Seleccionar categoría)</option>
                            <?php
                                llenar_combo("SELECT id, nombre FROM categoria ORDER BY nombre LIMIT 1000");
                            ?>        
                        </select>
                        <div class="help-block with-errors"></div>
                    </div>
                </div>                

                <div class="form-group row">
                    <label class="control-label col-sm-2" for="orden">Orden</label>
                    <div class="col-sm-10">
                        <input type="number" id="orden" name="orden" class="form-control form-control-sm" 
                            placeholder="Orden"/>
                        <div class="help-block with-errors"></div>
                    </div>
                </div>

                <div class="form-group row">
                    <label class="control-label col-sm-2" for="nombre">Nombre</label>
                    <div class="col-sm-10">
                        <!--
                        <input type="text" id="nombre" name="nombre" class="form-control form-control-sm"
                            maxlength="120" placeholder="Nombre" required/> -->
                            

                        <textarea type="text" id="nombre" name="nombre" class="form-control form-control-sm"
                            maxlength="250" placeholder="Nombre" required rows="2"/></textarea>
                            
                        <div class="help-block with-errors"></div>
                    </div>
                </div>


                <div class="form-group row">
                    <label class="control-label col-sm-2" for="nombre">TRL</label>
                    <div class="col-sm-10">
                        <?php
                            for ($i=1;$i<=9;$i++) { 
                        ?>
                            <div class="form-check form-check-inline">
                                <input class="form-check-input" type="checkbox" 
                                    id="trl[<?php echo $i ?>]" 
                                    name="trl[<?php echo $i ?>]" 
                                    value="<?php echo $i ?>">
                                <label class="form-check-label" for="trl_<?php echo $i ?>"><?php echo $i ?></label>
                            </div>
                        <?php
                            }
                        ?>
                    </div>
                </div>                
 
                <div class="form-group row">
                    <label class="control-label col-sm-2" for="nombre">BRL</label>
                    <div class="col-sm-10">
                        <?php
                            for ($i=1;$i<=9;$i++) { 
                        ?>
                            <div class="form-check form-check-inline">
                                <input class="form-check-input" type="checkbox" 
                                    id="brl_<?php echo $i ?>" 
                                    name="brl[<?php echo $i ?>]" 
                                    value="<?php echo $i ?>">
                                <label class="form-check-label" for="brl_<?php echo $i ?>"><?php echo $i ?></label>
                            </div>
                        <?php
                            }
                        ?>
                    </div>
                </div>    

                <div class="form-group form-btns-actions-right mb-0">
                    <input type="button" class="btn btn-sm btn-success btn-aceptar" value="Guardar">
                    <input type="button" class="btn btn-sm btn-secondary btn-regresar" value="Regresar">
                </div>
                
                <div class="working no-show"></div>
            </form>
        </div>
    </div>
</div>

<script type="text/javascript">
    var f = new Formulario();

    f._Agregar = f.Agregar;

    f.Agregar = function () {
       
        if($("#f-categoria").val()!="") {
            f._Agregar();
            $("#categoria_id").val( $("#f-categoria").val() );
            $("#categoria_id").prop("disabled", true);
        }
    };


    $("#f-categoria").change(function () {
        let url = PAGE_PATH + "listar?categoria_id=" + $('#f-categoria').val();

        $("#tabla").bootstrapTable('refresh', {url: url});
    });
</script>