<?php

// Autor: Deiner Mena Waldo
// Modifición: 2015-06-07


require_once("DbBase.php");

$errors = array();
// $errors['1451'] = "No se puede actualizar o eliminar el registro, debido a que tiene otros registros vinculados (1).";
// $errors['1452'] = "No se puede actualizar o eliminar el registro, debido a que tiene otros registros vinculados (2)."; //Fallo en la llave foranea

class DbMySQL extends DbBase {

    public function __construct() {
        $this->transation_errors = "";
        $this->transation_num_errors = 0;
        $this->transtation_details = array();
    }

    function connect($host, $username, $passwd, $dbname, $port) {
        $this->link_identifier = mysqli_connect($host, $username, $passwd, $dbname, $port);
        return $this->link_identifier;
    }

    function pconnect($host, $username, $passwd, $dbname, $port) {
        $this->link_identifier = mysqli_connect($host, $username, $passwd, $dbname, $port);
        return $this->link_identifier;
    }

    function connect_error() {
        return mysqli_connect_error();
    }

    function close() {
        return mysqli_close($this->link_identifier);
    }

    function select_db($database_name) {
        return true;
    }

    function query($query) {
        $result = mysqli_query($this->link_identifier, $query);


        //Controles para transaciones
        $error = $this->error();
        if ($error != "") {
            $this->transation_errors .= $error . "\n\n";
            $this->transation_num_errors ++;
        }

        $details = array();
        $details['query'] = $query;
        $details['error'] = $error;
        $details['result'] = $result;
        $this->transtation_details[] = $details;
        //echo $this->error();
        return $result;
    }

    function error() {
        global $errors;

        $errno = mysqli_errno($this->link_identifier);
        $error = mysqli_error($this->link_identifier);

        if (isset($errors[$errno])) {
            $error = $errors[$errno];
        }

        if ($error == "") {
            return "";
        } else {
            return "Error $errno: $error";
        }
    }

    function affected_rows() {
        return mysqli_affected_rows($this->link_identifier);
    }

    function last_insert_id($sequence = NULL) {
        $id = mysqli_insert_id($this->link_identifier);
        return ($id == 0 ? NULL : $id);
    }

    function result($result, $row, $field = NULL) {
        //return mysqli_fetch_result($result, $row, $field);
    }

    function num_rows($result) {
        return mysqli_num_rows($result);
    }

    function fetch_row($result) {
        return mysqli_fetch_row($result);
    }

    function fetch_array($result, $result_type = MYSQLI_BOTH) {
        return mysqli_fetch_array($result, $result_type);
    }

    function fetch_assoc($result) {
        $r = mysqli_fetch_assoc($result);
        //echo $this->error();
        return $r;
    }

    function fetch_object($result, $class_name = NULL, array $params = NULL) {
        return mysqli_fetch_object($result, $class_name, $params);
    }

    function data_seek($result, $row_number) {
        return mysqli_data_seek($result, $row_number);
    }

    function free_result($result) {
        return mysqli_free_result($result);
    }

    function escape_string($unescaped_string) {
        if (is_array($unescaped_string))
            return $unescaped_string;
        return mysqli_real_escape_string($this->link_identifier, $unescaped_string);
    }

    function set_charset($charset) {
        return mysqli_set_charset($this->link_identifier, $charset);
    }

    function num_fields($result) {
        return mysqli_num_fields($result);
    }

    function field_name($result, $field_number) {
        return $result->field_name($result, $field_number);
    }

    function fetch_field($result) {
        return mysqli_fetch_field($result);
    }

    function fetch_fields($result) {
        return mysqli_fetch_fields($result);
    }

}

?>