<?php

class ExportExcel {

    function Export1($sql, $Encabezado = "", $archivo = "reporte.xlsx") {
        global $db;
        $numeric_types = array(16, 1, 2, 9, 3, 8, 4, 5, 246, 246, 246); //Tipos de datos numeros en Mysql

        require_once("xlsxwriter.class.php");
        ini_set('display_errors', 1);
        ini_set('log_errors', 1);
        error_reporting(E_ALL & ~E_NOTICE);

        $rs = $db->query($sql);
        $titulos = array();
        $tipos = array();


        while ($f = $db->fetch_field($rs)) {
            $nom = mb_strtoupper($f->name);
            $titulos[$nom] = in_array($f->type, $numeric_types) ? "numeric" : "string";
        }

        $data = array();



        while ($rw = $db->fetch_row($rs)) {
            foreach ($rw as $index => $value) {
                $rw[$index] = strval($value);
            }
            $data[] = $rw;
        }
        $writer = new XLSXWriter();
        $writer->setAuthor("");

        if (trim($Encabezado) !== "") {
            $lineas = explode("\n", $Encabezado);
            foreach ($lineas as $ln) {
                $row = [];
                $row[0] = $ln;
                $writer->writeSheetRow("Hoja1", $row);
                //$data[] = $ln;
            }


            //Fila en blanco
            $row = [];
            $row[] = "";
            $writer->writeSheetRow("Hoja1", $row);

            //Titulos
            $row = [];
            foreach ($titulos as $k => $v) {
                $row[] = $k;
            }
            $writer->writeSheetRow("Hoja1", $row);
        }

        //Contenido
        $writer->writeSheet($data, 'Hoja1', $titulos);

        //Enviar
        header('Content-disposition: attachment; filename="' . XLSXWriter::sanitize_filename($archivo) . '"');
        header("Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        header('Content-Transfer-Encoding: binary');
        header('Cache-Control: must-revalidate');
        header('Pragma: public');

        $writer->writeToStdOut();

        exit(0);
    }

    function Export2($archivo, $sql) {
        $inicio = microtime(true);
        global $db;
        error_reporting(E_ALL);
        ini_set('display_errors', TRUE);
        ini_set('display_startup_errors', TRUE);


        require_once ('php/PHPExcel/PHPExcel.php');

        $numeric_types = array(16, 1, 2, 9, 3, 8, 4, 5, 246, 246, 246); //Tipos de datos numeros en Mysql

        $objPHPExcel = new PHPExcel();

        $objPHPExcel->setActiveSheetIndex(0);
        $worksheet = $objPHPExcel->getActiveSheet();
        $worksheet->setTitle('Hoja1');

        $fila = 1;
        $rs = $db->query($sql);
        $titulos = array();
        $tipos = array();

        $num_filas = $db->num_rows($rs) + 1;
        $num_col = $db->num_fields($rs) + 1;

        $worksheet->insertNewRowBefore(1, $num_filas);

        while ($f = $db->fetch_field($rs)) {
            $titulos[] = mb_strtoupper($f->name);
            $tipos[] = $f->type;
            //print_r($f);
        }
        $worksheet->fromArray($titulos, NULL, 'A' . $fila++);



        /*
          $currentColumn = $startColumn;
          echo "<pre>";
          var_dump($startColumn);
          var_dump($startRow);
          for ($i = 0; $i < 50; $i++) {
          ++$currentColumn;
          var_dump($currentColumn);
          }
          exit(0);
         */

        //

        /*
          while ($rw = $db->fetch_assoc($rs)) {
          $worksheet->fromArray($rw, NULL, 'A' . $fila++);
          } */
        //echo "xXX";
        //
    //print_r($tipos);
        //exit(0);


        while ($rw = $db->fetch_row($rs)) {


            $col = 0;
            foreach ($rw as $value) {
                $type = in_array($tipos[$col], $numeric_types) ?
                        PHPExcel_Cell_DataType::TYPE_NUMERIC :
                        PHPExcel_Cell_DataType::TYPE_STRING;

                $worksheet->setCellValueExplicitByColumnAndRow($col++, $fila, $value, $type);
            }

            $fila++;
        }

        for ($col = 'A'; $col !== 'G'; $col++) {
            $objPHPExcel->getActiveSheet()
                    ->getColumnDimension($col)
                    ->setAutoSize(true);
        }

        $fin = microtime(true);

        $time = $fin - $inicio;
        $time = $time;
        $mem = memory_get_usage(true) / 1024 / 1024;
        //echo "Tiempo 1: $time <br/>";
        //echo "Mem 1: $mem <br/>";
        /*
          // Redirect output to a client’s web browser (Excel2007)
          header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
          header('Content-Disposition: attachment;filename="' . $archivo . '.xlsx"');
          header('Cache-Control: max-age=0');
          // If you're serving to IE 9, then the following may be needed
          header('Cache-Control: max-age=1');

          // If you're serving to IE over SSL, then the following may be needed
          header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
          header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
          header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
          header('Pragma: public'); // HTTP/1.0
         */
        //
        //$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        //$objWriter->save('d.xsls');

        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
        //$objWriter->save('php://output');
        //$objWriter->save('d3.xlsx');
        $fin = microtime(true);

        $time = $fin - $inicio;
        $time = $time;
        $mem = memory_get_usage(true) / 1024 / 1024;
    }

}

?>