<?php

/**
 * Description of Menu
 *
 * @author deiner
 */
class Menu
{
    /* @var $db DbMySQL */

    protected $db;
    private $Menu;
    private $Archivo;
    private $AccesosPermitidos;
    private $PermisosMenu;
    private $PermisosAccion;

    function __construct($Archivo)
    {
        $this->db = $GLOBALS['db'];

        $this->Archivo = $Archivo;

        if (!isset($_SESSION['accesos_permitidos'])) {
            $_SESSION['accesos_permitidos'] = [1, 2];
        }

        $this->AccesosPermitidos = $_SESSION['accesos_permitidos'];
    }

    public function Cargar()
    {
        $db = $this->db;

        $this->Menu = [];
        $XmlMenu = simplexml_load_file($this->Archivo);

        $this->PermisosMenu = [];
        $this->PermisosAccion = [];

        if (isset($_SESSION['usuario_roles']) && $_SESSION['usuario_roles'] != "") {
            $roles = $_SESSION['usuario_roles'];
            $rs = $db->query("SELECT * FROM admin_permiso_menu WHERE rol IN ($roles)");
            while ($rw = $db->fetch_assoc($rs)) {
                $m = $rw['menu'];
                $this->PermisosMenu[$m] = true;
            }


            $rs = $db->query("SELECT * FROM admin_permiso_accion WHERE rol  IN ($roles)");
            while ($rw = $db->fetch_assoc($rs)) {
                $m = $rw['menu'];
                $a = $rw['accion'];
                $this->PermisosAccion[$m][$a] = true;
            }
        }

        $this->CargarMenu($XmlMenu);
    }

    private function CargarMenu($MenuPadre, $IdPadre = "", $Titulo = "")
    {
        $a = $MenuPadre->attributes();

        foreach ($MenuPadre->item as $m) {
            $id = (string) $m['id'];
            if ($id == "") {
                return;
            }


            $this->Menu[$id] = array();
            $this->Menu[$id]['padre'] = $IdPadre;
            $TituloComleto = trim("$Titulo | {$m['titulo']} ", "| ");
            $this->Menu[$id]['titulo-completo'] = $TituloComleto;

            foreach ($m->attributes() as $key => $value) {
                $key = (string) $key;
                $value = (string) $value;
                $this->Menu[$id][$key] = $value;
            }

            if ($this->Menu[$id]['tipo-acceso'] == "7") {
                if (isset($this->PermisosMenu[$id])) {
                    $this->Menu[$id]['permitir-menu'] = "S";
                } else {
                    $this->Menu[$id]['permitir-menu'] = "N";
                }
            } else {
                $this->Menu[$id]['permitir-menu'] = "S";
            }


            if (isset($m->menu) === false) {

                $this->Menu[$id]['acciones'] = array();
                if (isset($m->acciones) === true) {
                    foreach ($m->acciones->accion as $a) {

                        $accion_id = (string) $a['id'];
                        $this->Menu[$id]['acciones'][$accion_id] = array();


                        foreach ($a->attributes() as $key => $value) {
                            $key = (string) $key;
                            $value = (string) $value;
                            $this->Menu[$id]['acciones'][$accion_id][$key] = $value;
                        }

                        if ($this->Menu[$id]['tipo-acceso'] == "7" && isset($a['permiso-individual']) && $a['permiso-individual'] == "S") {
                            if (isset($this->PermisosAccion[$id]) && isset($this->PermisosAccion[$id][$accion_id])) {
                                $this->Menu[$id]['acciones'][$accion_id]['permitir-accion'] = "S";
                            } else {
                                $this->Menu[$id]['acciones'][$accion_id]['permitir-accion'] = "N";
                            }
                        } else {
                            $this->Menu[$id]['acciones'][$accion_id]['permitir-accion'] = "S";
                        }

                        if (in_array($this->Menu[$id]['tipo-acceso'], $this->AccesosPermitidos) === false) {
                            $this->Menu[$id]['acciones'][$accion_id]['permitir-accion'] = "N";
                        }

                        if ($a['predeterminada'] == "S") {
                            $this->Menu[$id]['accion-predeterminada'] = $accion_id;
                        }
                    }
                }
            } else {
                $this->CargarMenu($m->menu, $id, $TituloComleto);
            }
        }
    }

    function GetMenuArray()
    {
        return $this->Menu;
    }

    function GenerarHTML($Padre = "", $Nivel = 1)
    {
        if ($Nivel > 4) {
            return;
        }


        foreach ($this->Menu as $m) {
            if ($m['padre'] === $Padre && $m['visible'] == "S" && in_array($m['tipo-acceso'], $this->AccesosPermitidos)) {

                if (isset($m['accion-predeterminada'])) {
                    $href = SITE_PATH . $m['id'] . "/" . $m['accion-predeterminada'];
                } else {
                    $href = "javascript:;";
                }

                // $href = "#";
                if (isset($m['acciones']) === true) {
                    echo "<li> <a href='$href'>$m[titulo]</a> </li>";
                } else {
                    if ($Nivel <= 1) {
                        echo "<li class='dropdown'> ";
                    } else {
                        echo "<li class='dropdown-submenu'> ";
                    }

                    echo " <a href='$href' class='dropdown-toggle' data-toggle='dropdown'>$m[titulo]</a> ";
                    echo "<ul class='dropdown-menu multi-level'>";
                    $this->GenerarHTML($m['id'], $Nivel + 1);
                    echo "</ul>";
                    echo "</li>";
                }
            }
        }
    }

    function GenerarHTML2($Padre = "", $Nivel = 1)
    {
        if ($Nivel > 4) {
            return;
        }
        if ($Padre != "") {
            if ($Nivel == 2) {
                echo "<ul class='nav nav-second-level'>";
            } else if ($Nivel == 3) {
                echo "<ul class='nav nav-third-level'>";
            } else {
                echo "<ul class='nav'>";
            }
        }

        foreach ($this->Menu as $m) {

            if ($m['padre'] === $Padre && $m['visible'] == "S" && in_array($m['tipo-acceso'], $this->AccesosPermitidos)) {

                if (isset($m['accion-predeterminada'])) {
                    $href = SITE_PATH . $m['id'] . "/" . $m['accion-predeterminada'];
                } else {
                    $href = "javascript:;";
                }


                if ($m['permitir-menu'] == "S") {
                    $class = "disponible";
                    $icono = "<i class='fa  fa-check-circle fa-fw'></i>  ";
                } else {
                    $icono = "<i class='fa  fa-times-circle fa-fw'></i>  ";
                    $class = "no-disponible";
                }
                if (isset($m['acciones']) === true) {
                    echo "<li class='$class' id='menu-$m[id]'> <a href='$href'> $icono $m[titulo]</a>";
                    echo "</li>";
                } else {

                    echo "<li class='$class' id='menu-$m[id]'> "
                        . " <a href='javascript:;'> $icono $m[titulo] "
                        . "<span class='fa arrow'></span>"
                        . "</a>";
                    $this->GenerarHTML2($m['id'], $Nivel + 1);
                    echo "</li>";
                }
            }
        }

        if ($Padre != "") {
            echo "</ul>";
        }
    }

    function GenerarHTML3($Padre = "", $Nivel = 1)
    {
        if ($Nivel > 4) {
            return;
        }

        echo "<ul class='nav' data-menu='$Padre' style='display:none'>";

        if ($Padre != "") {
            $icono = "<i class='fa  fa-check-circle fa-fw'></i>  ";
            $class = "disponible";

            $MenuAnterior = $this->Menu[$Padre]['padre'];
            echo "<li class='$class'> "
                . " <a href='javascript:;' data-expandir='$MenuAnterior'> $icono Regresar "
                . "<span class='fa arrow'></span>"
                . "</a>"
                . "</li>";
        }

        foreach ($this->Menu as $m) {
            if ($m['padre'] === $Padre && $m['visible'] == "S") {
                if (isset($m['accion-predeterminada'])) {
                    $href = SITE_PATH . $m['id'] . "/" . $m['accion-predeterminada'];
                } else {
                    $href = "javascript:;";
                }
                $class = "disponible";

                if ($m['permitir-menu'] == "S") {
                    $icono = "<i class='fa  fa-check-circle fa-fw'></i>  ";
                } else {
                    $icono = "<i class='fa  fa-times-circle fa-fw'></i>  ";
                }


                //
                if (isset($m['acciones']) === true) {
                    echo "<li class='$class' id='menu-$m[id]'> <a href='$href'> $icono $m[titulo]</a>";
                    echo "</li>";
                } else {
                    echo "<li class='$class'> "
                        . " <a href='javascript:;' data-expandir='$m[id]'> $icono $m[titulo] "
                        . "<span class='fa arrow'></span>"
                        . "</a>"
                        . "</li>";
                }
            }
        }
        echo "</ul>";

        foreach ($this->Menu as $m) {
            if ($m['padre'] === $Padre && $m['visible'] == "S") {
                if (isset($m['acciones']) === false) {
                    $this->GenerarHTML3($m['id'], $Nivel + 1);
                }
            }
        }
    }

    //mentisMenu v2.7.7
    function GenerarHTML4($Padre = "", $Nivel = 1)
    {
        if ($Nivel > 4) {
            return;
        }
        if ($Padre != "") {

            echo "<ul aria-expanded='true'>";
        }

        foreach ($this->Menu as $m) {

            if ($m['padre'] === $Padre && $m['visible'] == "S" && in_array($m['tipo-acceso'], $this->AccesosPermitidos)) {

                if (isset($m['accion-predeterminada'])) {
                    $href = SITE_PATH . $m['id'] . "/" . $m['accion-predeterminada'];
                } else {
                    $href = "javascript:;";
                }


                if ($m['permitir-menu'] == "S") {
                    $class = "disponible";
                    // $icono = "<i class='fa  fa-check-circle fa-fw'></i>  ";
                } else {
                    // $icono = "<i class='fa  fa-times-circle fa-fw'></i>  ";
                    $class = "no-disponible";
                }
                if (isset($m['acciones']) === true) {
                    echo "<li class='$class' id='menu-$m[id]'><a href='$href'>$m[titulo]</a>";
                    echo "</li>";
                } else {

                    echo "<li class='$class' id='menu-$m[id]'>"
                        . "<a href='javascript:;'>$m[titulo] "
                        . "<span class='fa arrow'></span>"
                        . "</a>";
                    $this->GenerarHTML4($m['id'], $Nivel + 1);
                    echo "</li>";
                }
            }
        }

        if ($Padre != "") {
            echo "</ul>";
        }
    }

    function GenerarHTML5($Padre = "", $Nivel = 1)
    {
        if ($Nivel > 4) {
            return;
        }
        if ($Padre != "") {
            if ($Nivel == 2) {
                echo "<ul class='nivel-2'>";
            } else if ($Nivel == 3) {
                echo "<ul class='nivel-3'>";
            } else {
                echo "<ul class=''>";
            }
        }

        foreach ($this->Menu as $m) {

            if ($m['padre'] === $Padre && $m['visible'] == "S" && in_array($m['tipo-acceso'], $this->AccesosPermitidos)) {

                if (isset($m['accion-predeterminada'])) {
                    $href = SITE_PATH . $m['id'] . "/" . $m['accion-predeterminada'];
                } else {
                    $href = "javascript:;";
                }

                $class = isset($m['class']) ? $m['class'] . " " : "";

                

                if ($m['permitir-menu'] == "S") {
                    $class .= "disponible";
                    $icono = "<i class='fa  fa-check-circle'></i>  ";
                } else {
                    $icono = "<i class='fas  fa-exclamation-circle'></i>  ";
                    $class .= "no-disponible";
                }


                $class=trim($class);

                if (isset($m['acciones']) === true) {
                    echo "<li class='$class' id='menu-$m[id]'> <a href='$href'> $icono <b>$m[titulo]</b></a>";
                    echo "</li>";
                } else {

                    echo "<li class='$class' id='menu-$m[id]'> "
                        . " <a href='javascript:;'> $icono <b>$m[titulo] <span class='fa arrow'></span> </b> "
                        . "  "
                        . "</a>";
                    $this->GenerarHTML5($m['id'], $Nivel + 1);
                    echo "</li>";
                }
            }
        }

        if ($Padre != "") {
            echo "</ul>";
        }
    }

    function GenerarJSON($Padre = "", $Nivel = 1)
    {
        if ($Nivel > 4) {
            return [];
        }
        $r = array();


        foreach ($this->Menu as $m) {
            if ($m['padre'] === $Padre) {
                $item = array();
                $item['id'] = $m['id'];

                $item['title'] = $m['titulo'];


                if (isset($m['acciones'])) {
                    $item['folder'] = false;
                    $item['expanded'] = false;
                } else {
                    $item['folder'] = true;
                    $item['expanded'] = false;
                }

                //                if (isset($m['acciones']) && count($m['acciones']) > 0) {
                //                    $item['children'] = array();
                //
                //                    foreach ($m['acciones'] as $accion) {
                //                        $a = array();
                //                        $a['id'] = $accion['id'];
                //                        $a['title'] = $accion['id'];
                //                        $a['folder'] = false;
                //                        $a['expanded'] = false;
                //
                //                        $item['children'][] = $a;
                //                    }
                //                } else {
                $item['children'] = $this->GenerarJSON($m['id'], $Nivel + 1);
                //                }
                if (count($item['children']) === 0) {
                    unset($item['children']);
                }
                $r[] = $item;
            }
            /*
              if (isset($m['accion-predeterminada'])) {
              $href = SITE_PATH . $m['id'] . "/" . $m['accion-predeterminada'];
              } else {
              $href = "javascript:;";
              }

              //$href = "#";
              if (isset($m['acciones']) === true) {
              echo "<li> <a href='$href'>$m[titulo]</a> </li>";
              } else {
              if ($Nivel <= 1) {
              echo "<li class='dropdown'> ";
              } else {
              echo "<li class='dropdown-submenu'> ";
              }

              echo " <a href='$href' class='dropdown-toggle' data-toggle='dropdown'>$m[titulo]</a> ";
              echo "<ul class='dropdown-menu multi-level'>";
              $this->GenerarHTML($m['id'], $Nivel + 1);
              echo "</ul>";
              echo "</li>";
              } */
        }
        return $r;
    }

    function GetMenuInfo($IdMenu, $IdAccion = null)
    {

        $Menu = $this->Menu[$IdMenu];

        if ($IdAccion === null && isset($Menu["accion-predeterminada"])) {
            $IdAccion = $Menu["accion-predeterminada"];
        }

        if (isset($Menu["acciones"][$IdAccion])) {
            $Menu['accion'] = $IdAccion;

            $Accion = $Menu["acciones"][$IdAccion];
            unset($Accion['id']);

            $Info = array_merge($Menu, $Accion);
            $Info["menu-valido"] = "S";

            $RutaCompleta = $Info["ruta"] . "/" . $Info['archivo'];
            $RutaCompleta = str_replace("//", "/", $RutaCompleta);
            $Info['ruta-completa'] = $RutaCompleta;
            $Info['ruta-valida'] = (file_exists($RutaCompleta) ? "S" : "N");

            if ($Info['permitir-menu'] !== "S" || $Info['permitir-accion'] !== "S") {
                $Info['mensaje-error'] = "Acceso denegado.";
            } else if ($Info['ruta-valida'] !== "S") {
                $Info['mensaje-error'] = "Ruta no valida.";
            }

            if (isset($Info['mensaje-error'])) {
                $Info['error'] = "S";
            } else {
                $Info['error'] = "N";
            }
        } else {
            $Info = $Menu;
            $Info["menu-valido"] = "N";
            $Info["tipo-respuesta"] = "error";
            $Info['error'] = "S";
            $Info['mensaje-error'] = "Menú no valido.";
        }
        //unset($Info["acciones"]);



        return $Info;
    }
}
