<?php

class PDFTable {
    /* @var $Pdf TCPDF */

    protected $db;
    protected $Cols;
    protected $RowEvenClass = "even";
    protected $RowOddClass = "odd";
    protected $CellPadding = "2";
    protected $FontSize = "8.5pt";
    protected $Pdf;

    public function __construct($Pdf) {
        $this->db = $GLOBALS['db'];


        $this->Pdf = $Pdf;
//        $args = func_get_args();
//        $num_args = func_num_args();
    }

    public function SetCols($Cols) {
        $this->Cols = $Cols;
    }

    public function SetFontSize($FontSize) {
        $this->FontSize = $FontSize;
    }

    public function setRowsClass($OddClass, $EvenClass = "") {
        $this->RowOddClass = $OddClass;
        $this->RowEvenClass = $EvenClass;
    }

    public function PdfMakeFromSQL($sql) {
        $db = $this->db;
        $aggregate = false;
        $cols = $this->Cols;
        $p = $this->Pdf;

        $Margins = $p->getMargins();

        //$BodyHeihgt = $p->getPageHeight() - $Margins['bottom'] - $Margins['top'];

        $BodyHeihgt = $p->getPageHeight() - $Margins['bottom'];
        $sums = [];
        foreach ($cols as $key => $c) {
            $sums[$key] = 0;
            $this->Cols[$key]['align'] = strtoupper(substr($c['align'], 0, 1));
            $cols[$key]['align'] = strtoupper(substr($c['align'], 0, 1));
        }


        //echo '<table style="font-size:' . $this->FontSize . '" cellpadding="' . $this->CellPadding . '" >';
        //Header
        //echo '<thead> <tr> ';
        $rs = $db->query($sql);

        $row = [];
        foreach ($cols as $key => $c) {
            $row[$key] = $c['title'];
        }
        $HeaderHeihgt = $this->GetRowHeihgt($row);
        foreach ($cols as $c) {
            $p->MultiCell($c['width'], $HeaderHeihgt, $c['title'], 1, $c['align'], 1, false);
        }
        $p->Ln();


        //Body
        $num = 1;

        while ($rw = $db->fetch_assoc($rs)) {
            $class = $num % 2 == 0 ? $this->RowOddClass : $this->RowEvenClass;

            $row = $rw;
            foreach ($cols as $key => $c) {
                $valor = isset($rw[$key]) ? $rw[$key] : "";
                if (isset($c['aggregate'])) {
                    $sums[$key] += $valor;
                    $aggregate = true;
                }
                if (isset($c["format"])) {
                    $valor = call_user_func($c["format"], $key, $rw, $num);
                }
                $row[$key] = $valor;
            }

            $h = $this->GetRowHeihgt($row);

            if ($p->GetY() + $h > $BodyHeihgt) {
                $p->AddPage();
                foreach ($cols as $c) {
                    $p->MultiCell($c['width'], $HeaderHeihgt, $c['title'], 1, 0, $c['align'], 0);
                }
                $p->Ln();
            }
//            if ($p->GetY() > 400) {
//                $p->AddPage();
//            }



            foreach ($cols as $key => $c) {
                $valor = $row[$key];
                //$p->MultiCell($c['width'], 40, $valor, 1, 'L', 0, 0, '', '', true);
                $p->MultiCell($c['width'], $h, $valor, 1, $c['align'], 0, false);
            }

//
//            $valor = $p->GetY();
//            $p->MultiCell(50, $h, $valor, 1, "L", 0, false);
////
////
//            $valor = $h;
//            $p->MultiCell(50, $h, $valor, 1, "L", 0, false);
//
//            $valor = $BodyHeihgt;
//            $p->MultiCell(50, $h, $valor, 1, "L", 0, false);
//
////
//            $valor = $p->getPageHeight() . "/" . $BodyHeihgt;
//            $p->MultiCell("80pt", 0, $valor, 1, "L", 0, 0, '', '', true);

            $p->Ln();
            //  $p->lastPage();
//            $html .= "</tr> </table>";
//            $p->writeHTML($html, true, 0, true, 0);
            //echo "</tr>";
            $num++;
        }


        //echo "</tbody>";
        //Footer
//
//        if ($aggregate === true) {
//            echo "<tfoot>";
//            $class = $num % 2 == 0 ? $this->RowOddClass : $this->RowEvenClass;
//            echo "<tr class=\"$class \" style=\"font-weight: bold;\">";
//            foreach ($cols as $key => $c) {
//                $valor = "";
//                if (isset($c['aggregate'])) {
//                    $valor = $sums[$key];
//                }
//
//                if (isset($c["format"])) {
//                    $valor = call_user_func($c["format"], $key, $sums, -1);
//                }
//
//                if (isset($c['show-total-text']) && $c['show-total-text'] === true) {
//                    echo "<td style=\"text-align: right; width: $c[width]\">TOTAL=></td> ";
//                } else {
//                    echo "<td style = \"text-align:$c[align]; width: $c[width]\">$valor</td>";
//                }
//            }
//            echo "</tr>";
//            echo "</tfoot>";
//        }
//
//        echo "</table>";
    }

    private function GetRowHeihgt($Row) {
        $p = $this->Pdf;
        $Cols = $this->Cols;
        $h = 0;

        foreach ($Cols as $key => $c) {

            $h2 = $p->getStringHeight($c['width'], $Row[$key], $reseth = true, $autopadding = true, $cellpadding = '', $border = 1);
            if ($h2 > $h) {
                $h = $h2;
            }
        }

        return $h;
    }

    public function MakeFromSQL($sql) {
        $db = $this->db;
        $aggregate = false;
        $cols = $this->Cols;

        $sums = [];
        foreach ($cols as $key => $c) {
            $sums[$key] = 0;
        }


        echo '<table style="font-size:' . $this->FontSize . '" cellpadding="' . $this->CellPadding . '" >';
        //Header
        echo '<thead> <tr> ';
        $rs = $db->query($sql);
        foreach ($cols as $c) {
            echo "<th style=\"text-align:$c[align]; width: $c[width]\">$c[title]</th>";
        }
        echo "</thead></tr>";

        //Body
        $num = 1;
        echo "<tbody>";
        while ($rw = $db->fetch_assoc($rs)) {
            $class = $num % 2 == 0 ? $this->RowOddClass : $this->RowEvenClass;
            echo "<tr class=\"$class\">";
            foreach ($cols as $key => $c) {

                $valor = isset($rw[$key]) ? $rw[$key] : "";
                if (isset($c['aggregate'])) {
                    $sums[$key] += $valor;
                    $aggregate = true;
                }

                if (isset($c["format"])) {
                    $valor = call_user_func($c["format"], $key, $rw, $num);
                }
                echo "<td style=\"text-align:$c[align]; width: $c[width]\">$valor</td>";
            }
            echo "</tr>";
            $num++;
        }
        echo "</tbody>";

        //Footer

        if ($aggregate === true) {
            echo "<tfoot>";
            $class = $num % 2 == 0 ? $this->RowOddClass : $this->RowEvenClass;
            echo "<tr class=\"$class \" style=\"font-weight: bold;\">";
            foreach ($cols as $key => $c) {
                $valor = "";
                if (isset($c['aggregate'])) {
                    $valor = $sums[$key];
                }

                if (isset($c["format"])) {
                    $valor = call_user_func($c["format"], $key, $sums, -1);
                }

                if (isset($c['show-total-text']) && $c['show-total-text'] === true) {
                    echo "<td style=\"text-align: right; width: $c[width]\">TOTAL=></td> ";
                } else {
                    echo "<td style = \"text-align:$c[align]; width: $c[width]\">$valor</td>";
                }
            }
            echo "</tr>";
            echo "</tfoot>";
        }

        echo "</table>";
    }

    public function MakeFromMatrix($matriz) {
        $cols = $this->Cols;

        echo '<table style="border-collapse:collapse; border: 1px solid ' . BORDE_HTML . '" border="1" cellpadding="2" cellspacing="0">';
        echo '<tr style="font-weight:bold; background-color:' . FONDO_HTML_TITULO . '">';

        $i = 0;
        foreach ($cols as $c) {
            echo "<td style=\"text-align:$c[align]; width: $c[width]\">$c[title]</td>";
        }
        echo "</tr>";

        foreach ($matriz as $rw) {
            $color = ($color == FONDO_HTML) ? "" : FONDO_HTML;
            echo "<tr style='background-color: $color'>";
            foreach ($cols as $key => $c) {
                $valor = $rw[$key];
                echo "<td style=\"text-align:$c[align]; width: $c[width]\">$valor</td>";
            }
            echo "</tr>";
        }
        echo "</table>";
    }

    public static function NumberFormat($field, $row, $index) {
        return number_format($row[$field], 0, ',', '.');
    }

    public static function RowNumber($field, $row, $index) {
        if ($index > 0) {
            return $index;
        } else {
            return "";
        }
    }

}
