<?php

class Table {

    protected $db;
    protected $Cols;
    protected $RowEvenClass = "even";
    protected $RowOddClass = "odd";
    protected $CellPadding = "2";
    protected $FontSize = "8.5pt";

    public function __construct() {
        $this->db = $GLOBALS['db'];

//        $args = func_get_args();
//        $num_args = func_num_args();
    }

    public function SetCols($Cols) {
        $this->Cols = $Cols;
    }

    public function SetFontSize($FontSize) {
        $this->FontSize = $FontSize;
    }

    public function setRowsClass($OddClass, $EvenClass = "") {
        $this->RowOddClass = $OddClass;
        $this->RowEvenClass = $EvenClass;
    }

    public function MakeFromSQL($sql) {
        $db = $this->db;
        $aggregate = false;
        $cols = $this->Cols;

        $sums = [];
        foreach ($cols as $key => $c) {
            $sums[$key] = 0;
        }


        echo '<table style="font-size:' . $this->FontSize . '" cellpadding="' . $this->CellPadding . '" >';
        //Header
        echo '<thead> <tr> ';
        $rs = $db->query($sql);
        foreach ($cols as $c) {
            echo "<th style=\"text-align:$c[align]; width: $c[width]\">$c[title]</th>";
        }
        echo "</thead></tr>";

        //Body
        $num = 1;
        echo "<tbody>";
        while ($rw = $db->fetch_assoc($rs)) {
            $class = $num % 2 == 0 ? $this->RowOddClass : $this->RowEvenClass;
            echo "<tr class=\"$class\">";
            foreach ($cols as $key => $c) {

                $valor = isset($rw[$key]) ? $rw[$key] : "";
                if (isset($c['aggregate'])) {
                    $sums[$key] += $valor;
                    $aggregate = true;
                }

                if (isset($c["format"])) {
                    $valor = call_user_func($c["format"], $key, $rw, $num);
                }
                echo "<td style=\"text-align:$c[align]; width: $c[width]\">$valor</td>";
            }
            echo "</tr>";
            $num++;
        }
        echo "</tbody>";

        //Footer

        if ($aggregate === true) {
            echo "<tfoot>";
            $class = $num % 2 == 0 ? $this->RowOddClass : $this->RowEvenClass;
            echo "<tr class=\"$class \" style=\"font-weight: bold;\">";
            foreach ($cols as $key => $c) {
                $valor = "";
                if (isset($c['aggregate'])) {
                    $valor = $sums[$key];
                }

                if (isset($c["format"])) {
                    $valor = call_user_func($c["format"], $key, $sums, -1);
                }

                if (isset($c['show-total-text']) && $c['show-total-text'] === true) {
                    echo "<td style=\"text-align: right; width: $c[width]\">TOTAL=></td> ";
                } else {
                    echo "<td style = \"text-align:$c[align]; width: $c[width]\">$valor</td>";
                }
            }
            echo "</tr>";
            echo "</tfoot>";
        }

        echo "</table>";
    }

    public function MakeFromMatrix($matriz) {
        $cols = $this->Cols;

        echo '<table style="border-collapse:collapse; border: 1px solid ' . BORDE_HTML . '" border="1" cellpadding="2" cellspacing="0">';
        echo '<tr style="font-weight:bold; background-color:' . FONDO_HTML_TITULO . '">';

        $i = 0;
        foreach ($cols as $c) {
            echo "<td style=\"text-align:$c[align]; width: $c[width]\">$c[title]</td>";
        }
        echo "</tr>";

        foreach ($matriz as $rw) {
            $color = ($color == FONDO_HTML) ? "" : FONDO_HTML;
            echo "<tr style='background-color: $color'>";
            foreach ($cols as $key => $c) {
                $valor = $rw[$key];
                echo "<td style=\"text-align:$c[align]; width: $c[width]\">$valor</td>";
            }
            echo "</tr>";
        }
        echo "</table>";
    }

    public static function NumberFormat($field, $row, $index) {
        return number_format($row[$field], 0, ',', '.');
    }

    public static function RowNumber($field, $row, $index) {
        if ($index > 0) {
            return $index;
        } else {
            return "";
        }
    }

}
