<?php

function escape_string($v) {
    global $db;
    return $db->escape_string($v);
}

function MakeToken($length) {
    $token = "";
    $chrs = ['a', 'b', 'c', 'd', 'e', 'f', 'g', 'h',
        'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q',
        'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z',
        'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I',
        'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R',
        'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z',
        '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'];
    //62 caracteres 

    for ($i = 0; $i < $length; $i++) {
        //[A-Z] //64-90
        //[a-z] //97-122
        //$token .= chr(rand(97, 122));
        $index = rand(0, count($chrs) - 1);
        $token .= $chrs[$index];
    }

    return $token;
}

function clave($clave, $extra1 = "XP", $extra2 = "?=^-") {
    if (CRYPT_SHA512 == 1) {
        $salt1 = "{$extra1}=&#/()x";
        $salt2 = "{$extra1}6=&*y";
        $v = crypt($clave, '$6$rounds=6000$' . $salt1 . '$');
        return strtoupper(md5(sha1($v) . md5($salt2) . sha1($extra2)));
    }
}

function NombreMes($Numero) {
    $Meses = array('Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio',
        'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre');

    return $Meses[$Numero - 1];
}

function llenar_combo($sql, $blanco = false, $predeterminado = "", $codificar = true) {
    global $db;
    $campos = array();
    $rs = @$db->query($sql);
    while ($f = $db->fetch_field($rs)) {
        $campos[] = $f->name;
    }

    $id = $campos[0];
    $text = $campos[1];

    if ($blanco == true) {
        foreach ($campos as $c) {
            if ($c != "id" && $c != "text") {
                $data .= "data-$c='' ";
            }
        }
        echo "<option value='' $data></option>";
    }


    $RID = new RandId(MENU);
    while ($rw = @$db->fetch_assoc($rs)) {
        $sel = (trim($rw[$id]) == $predeterminado) ? "selected='selected'" : "";
        if ($codificar === true) {
            $rw[$id] = $RID->GetRandId($rw[$id]);
        }

        $data = "";
        foreach ($campos as $c) {
            if ($c != "id" && $c != "text") {
                $v = $rw[$c];
                $data .= "data-$c='$v' ";
            }
        }
        echo "<option $sel value='{$rw[$id]}' $data>{$rw[$text]}</option>";
    }
}

function tabla_dato($sql) {
    $db = $GLOBALS['db'];


    echo '<table style=" width:100%; ; border-collapse:collapse; border: 1px solid ' . BORDE_HTML . '" border="1">';
    echo '<tr style="font-weight:bold; background-color:' . FONDO_HTML_TITULO . '">';
    $rs = $db->query($sql);
    $i = 0;
    while ($f = $db->fetch_field($rs)) {
        if ($i == 0) {
            echo "<td style='text-align:left'>" . $f->name . "</td>";
        } else {
            echo "<td style='text-align:left'>" . $f->name . "</td>";
        }

        $i++;
    }
    echo "</tr>";


    while ($rw = $db->fetch_row($rs)) {
        $color = ($color == FONDO_HTML) ? "" : FONDO_HTML;
        echo "<tr style='background-color: $color'>";
        foreach ($rw as $i => $v) {

            if ($i == 0) {
                //echo "<td style='font-weight:bold'>".$rw[$i]."</td>";
                echo "<td>" . $rw[$i] . "</td>";
            } else {
                echo "<td style='text-align:left'>" . $rw[$i] . "</td>";
            }
        }

        echo "</tr>";
    }


    echo "</table>";
}

function sql2xls($archivo, $sql) {
    global $db;
    $numeric_types = array(16, 1, 2, 9, 3, 8, 4, 5, 246, 246, 246); //Tipos de datos numeros en Mysql


    include_once("xlsxwriter.class.php");
    ini_set('display_errors', 1);
    ini_set('log_errors', 1);
    error_reporting(E_ALL & ~E_NOTICE);

    $rs = $db->query($sql);
    $titulos = array();
    $tipos = array();


    while ($f = $db->fetch_field($rs)) {
        $nom = mb_strtoupper($f->name);

        $titulos[$nom] = in_array($f->type, $numeric_types) ? "numeric" : "string";
        //print_r($f);
    }

    $data = array();
    while ($rw = $db->fetch_row($rs)) {
        foreach ($rw as $index => $value) {
            $rw[$index] = strval($value);
        }
        $data[] = $rw;
    }
    $writer = new XLSXWriter();
    $writer->setAuthor("");
    $writer->writeSheet($data, 'Hoja1', $titulos);

    header('Content-disposition: attachment; filename="' . XLSXWriter::sanitize_filename($archivo) . '"');
    header("Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
    header('Content-Transfer-Encoding: binary');
    header('Cache-Control: must-revalidate');
    header('Pragma: public');

    $writer->writeToStdOut();

    exit(0);
}

function sql2xls2($archivo, $sql) {
    $inicio = microtime(true);
    global $db;
    error_reporting(E_ALL);
    ini_set('display_errors', TRUE);
    ini_set('display_startup_errors', TRUE);


    require_once ('php/PHPExcel/PHPExcel.php');

    $numeric_types = array(16, 1, 2, 9, 3, 8, 4, 5, 246, 246, 246); //Tipos de datos numeros en Mysql

    $objPHPExcel = new PHPExcel();

    $objPHPExcel->setActiveSheetIndex(0);
    $worksheet = $objPHPExcel->getActiveSheet();
    $worksheet->setTitle('Hoja1');

    $fila = 1;
    $rs = $db->query($sql);
    $titulos = array();
    $tipos = array();

    $num_filas = $db->num_rows($rs) + 1;
    $num_col = $db->num_fields($rs) + 1;

    $worksheet->insertNewRowBefore(1, $num_filas);

    while ($f = $db->fetch_field($rs)) {
        $titulos[] = mb_strtoupper($f->name);
        $tipos[] = $f->type;
        //print_r($f);
    }
    $worksheet->fromArray($titulos, NULL, 'A' . $fila++);



    /*
      $currentColumn = $startColumn;
      echo "<pre>";
      var_dump($startColumn);
      var_dump($startRow);
      for ($i = 0; $i < 50; $i++) {
      ++$currentColumn;
      var_dump($currentColumn);
      }
      exit(0);
     */

    //

    /*
      while ($rw = $db->fetch_assoc($rs)) {
      $worksheet->fromArray($rw, NULL, 'A' . $fila++);
      } */
    //echo "xXX";
    //
    //print_r($tipos);
    //exit(0);


    while ($rw = $db->fetch_row($rs)) {


        $col = 0;
        foreach ($rw as $value) {
            $type = in_array($tipos[$col], $numeric_types) ?
                    PHPExcel_Cell_DataType::TYPE_NUMERIC :
                    PHPExcel_Cell_DataType::TYPE_STRING;

            $worksheet->setCellValueExplicitByColumnAndRow($col++, $fila, $value, $type);
        }

        $fila++;
    }

    for ($col = 'A'; $col !== 'G'; $col++) {
        $objPHPExcel->getActiveSheet()
                ->getColumnDimension($col)
                ->setAutoSize(true);
    }

    $fin = microtime(true);

    $time = $fin - $inicio;
    $time = $time;
    $mem = memory_get_usage(true) / 1024 / 1024;
    //echo "Tiempo 1: $time <br/>";
    //echo "Mem 1: $mem <br/>";
    /*
      // Redirect output to a client’s web browser (Excel2007)
      header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
      header('Content-Disposition: attachment;filename="' . $archivo . '.xlsx"');
      header('Cache-Control: max-age=0');
      // If you're serving to IE 9, then the following may be needed
      header('Cache-Control: max-age=1');

      // If you're serving to IE over SSL, then the following may be needed
      header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
      header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
      header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
      header('Pragma: public'); // HTTP/1.0
     */
    //
    //$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
    //$objWriter->save('d.xsls');

    $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
    //$objWriter->save('php://output');
    //$objWriter->save('d3.xlsx');
    $fin = microtime(true);

    $time = $fin - $inicio;
    $time = $time;
    $mem = memory_get_usage(true) / 1024 / 1024;
}

/*
 * Parameters:
 *     $string - The string to sanitize.
 *     $force_lowercase - Force the string to lowercase?
 *     $anal - If set to *true*, will remove all non-alphanumeric characters.
 */

//http://voragine.net/weblogs/funcion-php-para-limpiar-una-cadena-de-texto-y-usarla-como-url
function string_sanitize($string, $force_lowercase = true, $anal = false) {
    $strip = array("~", "`", "!", "@", "#", "$", "%", "^", "&", "*", "(", ")", "_", "=", "+", "[", "{", "]",
        "}", "\\", "|", ";", ":", "\"", "'", "&#8216;", "&#8217;", "&#8220;", "&#8221;", "&#8211;", "&#8212;",
        "â€”", "â€“", ",", "<", ".", ">", "/", "?");
    $clean = trim(str_replace($strip, "", strip_tags($string)));
    $clean = preg_replace('/\s+/', "-", $clean);
    $clean = ($anal) ? preg_replace("/[^a-zA-Z0-9]/", "", $clean) : $clean;
    return ($force_lowercase) ?
            (function_exists('mb_strtolower')) ?
            mb_strtolower($clean, 'UTF-8') :
            strtolower($clean) :
            $clean;
}
