<?php

class TCPDF_REPORTE extends TCPDF {

    var $LeftTitles;
    var $RightTitles;

    public function SetLeftTitles(... $Titles) {
        $this->LeftTitles = trim(implode("\n", $Titles));
    }

    public function SetRightTitles(... $Titles) {
        $this->RightTitles = trim(implode("\n", $Titles));
    }

    public function Header() {
        $line_width = $this->getPageWidth();
        $margins = $this->getMargins();

        $top = 1;
        $this->SetDrawColor(100,100,100);
        $this->SetLineWidth(1);
        $this->RoundedRect($margins['left'], $top, $line_width - $margins['right'] - $margins['left'], 58, 3, '1111');


        $this->Image("publico/general/img/logo_reporte.png", $margins['left'] + 5, $top + 3, 47);
        $this->SetFont('times', '', 10);
        $this->MultiCell($line_width - $margins['right'] - $margins['left'] - 59, 40, $this->LeftTitles, 0, "L", 0, 1, $margins['left'] + 56, $top + 3);
        $this->MultiCell($line_width - $margins['right'] - $margins['left'] - 59, 40, $this->RightTitles, 0, "R", 0, 1, $margins['left'] + 56, $top + 3);

        //$this->SetLineWidth($line_width);
    }

    public function Footer() {
        $this->SetFont('times', '', 10);
        $fecha = strftime("%A %d de %B del %Y - %H:%M:%S");
        $fecha = strtoupper($fecha);
//        $pagina_actual = $this->getGroupPageNo();
//        $paginas_total = $this->getPageGroupAlias();
//        if ($pagina_actual == '' && $paginas_total == '') {
        $pagina_actual = $this->getAliasNumPage();
        $paginas_total = $this->getAliasNbPages();
//        }
        //$pagina_actual = trim($pagina_actual);
        //$paginas_total = trim($paginas_total);
//
        $this->SetDrawColor(0);
        $this->Cell(200, 0, $fecha, "T", 0, "L");
        $this->Cell(0, 0, "Pagina $pagina_actual de $paginas_total", "T", 0, "R");
    }

}

?>