/**
 * @author Deiner Mena <deinermw.com>
 * version: 1.0
 * fecha: 2018-08-01
 */

(function ($) {
    'use strict';

    var BootstrapTable = $.fn.bootstrapTable.Constructor,
            _init = BootstrapTable.prototype.init,
            _initHeader = BootstrapTable.prototype.initHeader;

    BootstrapTable.prototype.init = function () {

        //if (this.options.filterControl) {
        var $table = this;

        this.$el.on('reset-view.bs.table', function () {

        }).on('post-header.bs.table', function () {
            //setValues(that);
            createFilters($table);
        }).on('post-body.bs.table', function () {
            /*
             if (that.options.height) {
             fixHeaderCSS(that);
             }*/
        }).on('column-switch.bs.table', function () {
            //setValues(that);
        });


        $table.options.filters = {};

        var _queryParams = $table.options.queryParams;
        if ($.isFunction(_queryParams) === true) {
            $table.options.queryParams = function () {
                var p = _queryParams.apply(this, Array.prototype.slice.apply(arguments));

                p.filters = $table.options.filters;
                //p.nombre = "ddd";
                //console.log(p);


                return p;
            }
        }

        _init.apply(this, Array.prototype.slice.apply(arguments));
    };

    BootstrapTable.prototype.initHeader = function () {
        _initHeader.apply(this, Array.prototype.slice.apply(arguments));

        //createFilters(this, this.$tableHeader);
    };



    var createFilters = function ($table) {
        $.each($table.columns, function (i, column) {
            //isVisible = 'hidden';
            //html = [];

            if (!column.visible) {
                return;
            }

            switch (column.filterType) {
                case "text":
                    createTextFilter($table, column);
                    break;
                case "select":
                    createSelectFilter($table, column);
                    break;
            }
            //console.log(column);
        });
    };

    var createTextFilter = function ($table, column) {
        var $th = $table.$tableHeader.find("th[data-field='" + column.field + "']");
        //$th.addClass("sortable");
        var valor = $table.options.filters[column.field];

        if (!valor) {
            $th.prepend("<span class='bs-table-filter-icon fa fa-search'></span>");
            valor = "";
        } else {
            $th.prepend("<span class='bs-table-filter-icon fa fa-filter'></span>");
            $th.addClass("bs-table-filtered");
        }
 

        $th.editable({
            title: "",
            highlight: false,
            placement: 'bottom',
            unsavedclass: "",
            inputclass: "bs-table-filter-text",
            value: valor,
            defaultValue: "",
            sourceCache: false,
            display: function (value) {
            },
            success: function (response, newValue) {
                var $icon = $th.find(".bs-table-filter-icon");
                if (newValue == "") {
                    $th.removeClass("bs-table-filtered");
                    $icon.removeClass("fa-filter");
                    $icon.addClass("fa-search");
                } else {
                    $th.addClass("bs-table-filtered");
                    $icon.addClass("fa-filter");
                    $icon.removeClass("fa-search");
                }
                $table.options.filters[column.field] = newValue;
                $table.refresh();
            }
        }).removeClass("editable editable-click")
                .on('shown', function (e, editable) {
                    var $p = editable.input.$input.parents(".editable-container");
                    $p.find(".popover-title").remove();
                });

    };
    var createSelectFilter = function ($table, column) {
        var $th = $table.$tableHeader.find("th[data-field='" + column.field + "']");
        //$th.addClass("sortable");
        var valor = $table.options.filters[column.field];

        if (!valor) {
            $th.prepend("<span class='bs-table-filter-icon fa fa-search'></span>");
            valor = "";
        } else {
            $th.prepend("<span class='bs-table-filter-icon fa fa-filter'></span>");
            $th.addClass("bs-table-filtered");
        }

        var source = column.filterSource;
        if (source) {
            $th.editable({
                title: "",
                highlight: false,
                placement: 'bottom',
                unsavedclass: "",
                inputclass: "bs-table-filter-select",
                value: valor,
                defaultValue: "",
                type: "select",
                source: source,
                prepend: "(No filtrar)",
                display: function (value) {
                },
                success: function (response, newValue) {
                    var $icon = $th.find(".bs-table-filter-icon");
                    if (newValue == "") {
                        $th.removeClass("bs-table-filtered");
                        $icon.removeClass("fa-filter");
                        $icon.addClass("fa-search");
                    } else {
                        $th.addClass("bs-table-filtered");
                        $icon.addClass("fa-filter");
                        $icon.removeClass("fa-search");
                    }
                    $table.options.filters[column.field] = newValue;
                    $table.refresh();
                }
            })
                    .removeClass("editable editable-click")
                    .on('shown', function (e, editable) {
                        var $p = editable.input.$input.parents(".editable-container");
                        $p.find(".popover-title").remove();
                    });
            ;
        }
    };
})(jQuery);