
(function ($) {

    "use strict";

    /* COMBOBOX PUBLIC CLASS DEFINITION
     * ================================ */

    var Cb = function (element, options) {

        var $this = this;


        this.options = $.extend({}, $.fn.cb.defaults, options);
        this.template = this.options.template || this.template;
        this.$source = $(element);

        this.$container = this.setup();
        this.$element = this.$container.find('input[type=text]');
        this.$target = this.$container.find('input[type=hidden]');
        this.$button = this.$container.find('.dropdown-toggle');

        this.options.cb = this;
        this.options.onSelect = function (item) {

            // console.log(this.cb);

            this.cb.$source.val(item.value);
        };


        this.init_typeahead();



//        this.$element.change(function (event) {
//            event.stopPropagation();
//            event.preventDefault();
//            var InputText = $(this).val();
//            var MenuText = $this.$container.find(".dropdown-menu").find('.active a').text();
//
//
//            console.log("1: " + InputText);
//            console.log("2: " + MenuText);
//
//            if (InputText !== MenuText) {
//                $(this).val("");
//            }
//
//            $this.$source.val("").trigger("change");
//        });
    };

    Cb.prototype = {
        constructor: Cb,
        setup: function () {
            var combobox = $(this.template());
            this.$source.before(combobox);
            // this.$source.hide();
            return combobox;
        },
        template: function () {
            var s;
            s = '<div class="cb-container"> \
                    <input type="hidden" /> \
                    <div class="input-group"> \
                        <input type="text" autocomplete="off" class="form-control form-control-sm" /> \
                        <span class="input-group-addon dropdown-toggle" data-dropdown="dropdown"> \
                            <span class="caret" ></span>  \
                            <span class="glyphicon glyphicon-remove" ></span> \
                        </span> \
                    </div> \
                </div>';
            return s;
        },
        init_typeahead: function () {

            this.options.select = function () {
                var $selectedItem = this.$menu.find('.active');
                if ($selectedItem.length) {
                    var value = $selectedItem.attr('data-value');
                    var text = this.$menu.find('.active a').text();

                    this.$element.val(this.updater(text)).change();

                    if (this.options.onSelect) {
                        this.options.onSelect({
                            value: value,
                            text: text
                        });
                    }
                }
                return this.hide();
            };
            
            this.options.updater=function(item) {
                console.log(item);
                return item;
            };
            
            this.$element.typeahead(this.options);

            //console.log(options);




        }
    };

    /* COMBOBOX PLUGIN DEFINITION
     * =========================== */
    $.fn.cb = function (option) {
        return this.each(function () {
            var $this = $(this);
            var data = $this.data('combobox');
            var options = typeof option == 'object' && option;
            if (!data) {
                $this.data('combobox', (data = new Cb(this, options)));
            }
            if (typeof option == 'string') {
                data[option]();
            }

        });
    };

    $.fn.cb.defaults = {

    };

    $.fn.cb.Constructor = Cb;




}(window.jQuery));
