function ControlInactividad(TiempoMaximoSesion, TiempoMostrarDialogo, SesionIniciada) {
    this.TiempoMaximoSesion = TiempoMaximoSesion;
    this.TiempoMostrarDialogo = TiempoMostrarDialogo;
    this.SesionIniciada = SesionIniciada;

    this.TiempoSesion = 0;
    this.DialogoInactividad = undefined;
    this.DialogoSesionTerminada = undefined;

    $(document).ajaxSend(function (event, jqxhr, settings) {
        this.TiempoSesion = 0;
    });


    this.MostrarDialogoInactividad = function () {
        var that = this;
        if (!this.DialogoInactividad && this.SesionIniciada) {

            this.DialogoInactividad = bootbox.dialog({
                title: 'La aplicación se cerrará por inactividad en: ',
                message: '<p style="font-size: 90px;" class="text-center cuenta-regresiva">' +
                        this.Tiempo(this.TiempoMaximoSesion - this.TiempoSesion + 1) +
                        '</p>',
                closeButton: false,
                buttons: {
                    confirm: {
                        label: 'Continuar trabajando',
                        className: 'btn-success',
                        callback: function () {
                            that.TiempoSesion = 0;
                            that.DialogoInactividad = undefined;
                            $.get(SITE_PATH + "ping/ping");
                        }
                    },
                    cancel: {
                        label: 'No voy a trabajar más',
                        className: 'btn-danger',
                        callback: function () {
                            location.replace(SITE_PATH + "salir/salir");
                        }
                    }
                }

            });


        }

    };

    this.MostrarDialogoSesionTerminada = function () {
        if (!this.DialogoSesionTerminada) {
            bootbox.hideAll()
            this.DialogoSesionTerminada = bootbox.dialog({
                title: 'Sesión terminada',
                message: '<p class="text-center" style="font-size:30px">Su sesión ha terminado por inactividad</p>',
                closeButton: false,
                buttons: {
                    confirm: {
                        label: 'Iniciar de nuevo',
                        className: 'btn-success',
                        callback: function () {
                            location.replace(SITE_PATH + "salir/salir");
                        }
                    }
                }
            });
        }


    };


    this.CalcularTiempoSesion = function () {
        $(".cuenta-regresiva").html(this.Tiempo(this.TiempoMaximoSesion - this.TiempoSesion));
        this.TiempoSesion++;

        if (this.TiempoMaximoSesion - this.TiempoSesion <= this.TiempoMostrarDialogo) {
            this.MostrarDialogoInactividad();
        }

        if (this.TiempoMaximoSesion - this.TiempoSesion <= 1) {
            //location.replace("/");
            this.MostrarDialogoSesionTerminada();
        }

    };

    this.Tiempo = function (Seg) {
        var str = "" + Seg;
        var pad = "000";
        str = pad.substring(0, pad.length - str.length) + str;
        str2 = "";
        for (var i = 0; i < str.length; i++) {
            str2 += str[i] + " ";
        }
        return str2;
    };

}