function Formulario() {
    var Obj = this; //Para hacer referencia al objecto principal(this) dentro de las funcniones internas		
    this.PKey = "";
    this.$table = $('#tabla');
    this.$formulario = $("#formulario");


    this.NotifyOkDelay = 3000;
    this.NotifyErrorDelay = 0;


    this.Mensajes = {
        ConfirmarEliminar: "¿Realmente desea eliminar el registro seleccionado?",
        ConfirmaModificar: "¿Realmente desea modificar el registro seleccionado?"
    };

    this.BloquearNoModifibles = function () {
        Obj.$formulario.find(".no-modificable").each(function () {
            this.disabled = true;
        });
    };

    this.BloquearEntradas = function () {
        var formulario = "formulario";
        Obj.$formulario.find("input[type!='button'], select, textarea").each(function () {
            this.disabled = true;
        });
    };

    this.DesbloquearEntradas = function () {

        Obj.$formulario.find("input[type!='button'], select, textarea").each(function () {
            this.disabled = false;
        });

    };

    this.Validar = function () {
        Obj.$formulario.validator('validate');

        if (Obj.$formulario.find(".has-error").length > 0) {
            //            $.notify(
            //                    {message: "No se puede procesar la solicitud debido a que se encontraron "
            //                                + "errores de validación en los campos.  Por favor, revise y corrija "
            //                                + "los campos marcados con color rojo para poder continuar. "},
            //                    {type: 'danger', delay: 0});
            return false;
        } else {
            return true;
        }

    };

    this.ValidarAgregar = function () {
        return this.Validar();
    };
    this.ValidarModificar = function () {
        return this.Validar();
    };

    this.MostrarFormulario = function (titulo) {
        $(".titulo-accion").html(titulo);
        $("#div-grid").hide();
        $("#div-formulario").show();
        $(".btn-aceptar").unbind("click");
        $(".btn-aceptar").show();

        $(".action-buttons").show();
        $(".working").hide();

        $.notifyClose();
    };


    this.Regresar = function () {
        $("#div-formulario").hide();
        $("#div-grid").show();

        $(window).trigger("resize");
        $.notifyClose();
    };

    this.Limpiar = function () {
        document.getElementById("formulario").reset();

        $('input[data-typeahead="yes"]').val("");

        $(".error").removeClass("error"); //Limpiar errores de validación
    };

    this.Valores = function () {

        var filtros = $(".filtros").serialize();

        var myform = Obj.$formulario;
        var disabled = myform.find(':input:disabled').removeAttr('disabled');
        var serialized = myform.serialize();
        disabled.attr('disabled', 'disabled');

        // console.log("xxxx");
        //console.log(myform);
        myform.find(".tiny-mce").each(function () {
            //console.log(this);
            // console.log("id: ", this.id);
            var content = URLEncode(tinymce.get(this.id).getContent());
            serialized = serialized.replace("&" + this.id + "=", "");
            serialized = serialized.replace(this.id + "=", "");
            serialized += "&" + this.id + "=" + content;
        });

        if (filtros === "") {
            return serialized;
        } else {
            return serialized + "&" + filtros;
        }

    };

    /* *********************************************************************************************************** */
    this.Agregar = function () {
        Obj.Limpiar();
        Obj.MostrarFormulario("Agregar");
        Obj.DesbloquearEntradas();
        $(".btn-aceptar").val("Guardar");

        $(".btn-aceptar").click(function () {
            if (Obj.ValidarAgregar() === false) {
                return; //Llamar a la funcion de validaci�n 
            }
            $(".action-buttons").hide();
            $(".working").show();
            //window.scrollTo(0, 0);
       
            $.post(PAGE_PATH + "agregar", Obj.Valores(), function (Data) {

                $(".action-buttons").show();
                $(".working").hide();

                try {
                    var r = jQuery.parseJSON(Data);
                    if (r.error === false) {
                        r.row.addrow = true;
                        Obj.$table.bootstrapTable('insertRow', { index: 0, row: r.row });
                        $("#div-formulario").hide();
                        $("#div-grid").show();
                        $(window).trigger("resize"); //Causar que se acutalice tamaño del Grid
                        $.notifyClose();
                        $.notify({ message: r.msg }, { type: 'success', delay: Obj.NotifyOkDelay });
                    } else {
                        $.notify({ message: r.msg }, { type: 'danger', delay: Obj.NotifyErrorDelay });
                    }
                } catch (Err) {
                    $.notify({ message: Err.message + "<br/>" + Data }, { type: 'danger', delay: 0 });
                }
            });
        });
    };

    this.Asignar = function (Value) {
        Obj.Limpiar();
        $(".working").show();
        $("#div-formulario").hide();

        $.get(PAGE_PATH + "asignar", Obj.PKey + "=" + Value, function (Data) {
            $(".working").hide();
            $("#div-formulario").show();
            try {
                asignar_json("formulario", Data);
            } catch (Err) {
                alert(Err.message);
            }
        });
    };

    this.Mostrar = function (e, value, row, index) {
        Obj.MostrarFormulario("Mostrar");

        var SelectedRows = Obj.$table.bootstrapTable("getSelections");
        if (SelectedRows.length > 0) {
            row = SelectedRows[0];
        }

        Obj.Asignar(row[Obj.PKey]);
        Obj.BloquearEntradas();
        $(".btn-aceptar").hide();
    };

    this.Modificar = function (e, value, row, index) {

        var SelectedRows = Obj.$table.bootstrapTable("getSelections");
        if (SelectedRows.length > 0) {
            // row = SelectedRows[0];
        }
        console.log(SelectedRows.length);
        var RowId = row[Obj.PKey];
        console.log(row);
        Obj.Limpiar();
        Obj.MostrarFormulario("Modificar");
        Obj.DesbloquearEntradas();
        Obj.Asignar(RowId);
        Obj.BloquearNoModifibles();
        $(".btn-aceptar").val("Guardar");

        $(".btn-aceptar").click(function () {

            if (Obj.ValidarModificar() === false) {
                return; //Llamar a la funcion de validaci�n 
            }

            bootbox.confirm(Obj.Mensajes.ConfirmaModificar, function (result) {
                if (result === true) {
                    $(".action-buttons").hide();
                    $(".working").show();
                    //window.scrollTo(0, 0);
                    $.post(PAGE_PATH + "modificar", Obj.Valores(), function (Data) {
                        $(".working").hide();
                        $(".action-buttons").show();
                        try {
                            var r = jQuery.parseJSON(Data);
                            if (r.error === false) {
                                r.row.addrow = true;
                                //console.log(RowId);
                                Obj.$table.bootstrapTable('updateByUniqueId', { id: RowId, row: r.row });
                                $("#div-formulario").hide();
                                $("#div-grid").show();
                                $(window).trigger("resize"); //Causar que se acutalice tamaño del Grid
                                $.notifyClose();
                                $.notify({ message: r.msg }, { type: 'success' });
                            } else {
                                $.notify({ message: r.msg }, { type: 'danger', delay: 0 });
                            }
                        } catch (Err) {
                            $.notify({ message: Err.message + "<br/>" + Data }, { type: 'danger', delay: 0 });
                        }
                    });
                }
            });
        });

    };

    this.Eliminar = function (e, value, row, index) {
        var SelectedRows = Obj.$table.bootstrapTable("getSelections");
        if (SelectedRows.length > 0) {
            row = SelectedRows[0];
        }

        var RowId = row[Obj.PKey];

        Obj.MostrarFormulario("Eliminar");
        Obj.Asignar(RowId);
        Obj.BloquearEntradas();
        $(".btn-aceptar").val("Eliminar");

        $(".btn-aceptar").click(function () {
            bootbox.confirm(Obj.Mensajes.ConfirmarEliminar, function (result) {
                if (result === true) {
                    $(".action-buttons").hide();
                    $(".working").show();

                    $.post(PAGE_PATH + "eliminar", Obj.Valores(), function (Data) {
                        $(".working").hide();
                        $(".action-buttons").show();

                        try {
                            var r = jQuery.parseJSON(Data);
                            if (r.error === false) {
                                //Obj.$table.bootstrapTable('remove', {field: Obj.PKey, values: [row[Obj.PKey]]});
                                Obj.$table.bootstrapTable('removeByUniqueId', RowId);
                                $("#div-formulario").hide();
                                $("#div-grid").show();
                                $(window).trigger("resize"); //Causar que se acutalice tamaño del Grid
                                $.notifyClose();
                                $.notify({ message: r.msg }, { type: 'success' });
                            } else {
                                $.notify({ message: r.msg }, { type: 'danger', delay: 0 });
                            }
                        } catch (Err) {
                            $.notify({ message: Err.message + "<br/>" + Data }, { type: 'danger', delay: 0 });
                        }
                    });

                }
            });
        });
    };


    this.RefrescarBotones = function () {
        var SelectedRows = Obj.$table.bootstrapTable("getSelections");

        // console.log(SelectedRows);
        if (SelectedRows.length === 0) {
            $("#toolbar button").hide();
            $("#toolbar button.no-ocultar").show();
            $("#toolbar #btn-agregar, #toolbar .btn-agregar").show(); //Para modelos antiguos
        } else {
            $("#toolbar button").show();
        }

    };


    this.Iniciar = function () {
        Obj.PKey = Obj.$table.attr("data-unique-id");

        $(".btn-regresar").click(function () {
            Obj.Regresar();
        });

        $(".btn-agregar").click(function () {
            Obj.Agregar();
        });

        $(".btn-mostrar").click(function () {
            Obj.Mostrar();
        });

        $(".btn-modificar").click(function () {
            Obj.Modificar();
        });

        $(".btn-eliminar").click(function () {
            Obj.Eliminar();
        });

        $(".btn-nuevo").click(function () {
            window.location.reload();
        });


        Obj.$table.on('check.bs.table', function (e) {
            Obj.RefrescarBotones();
        });

        Obj.$table.on('uncheck.bs.table', function (e) {
            Obj.RefrescarBotones();
        });

        Obj.$table.on('load-success.bs.table', function (e) {
            Obj.RefrescarBotones();
        });

        window.operateFormatter = function (value, row, index) {
            var iconos = "";
            iconos += " <a class='fa fa-eye mostrar' title='Mostrar'></a> ";
            iconos += " <a class='fa fa-edit modificar' title='Modificar'></a> ";
            iconos += " <a class='fa fa-trash eliminar' title='Eliminar'></a>";
            return iconos;
        };

        window.operateEvents = {
            'click .mostrar': Obj.Mostrar,
            'click .modificar': Obj.Modificar,
            'click .eliminar': Obj.Eliminar
        };

        $(window).resize(function () {
            Obj.$table.bootstrapTable('resetView', {
                height: getHeight()
            });
        });

        window.getHeight = function () {
            return $(window).height() - TABLE_BOTTOM_MARGIN;
        };

        $(document).ready(function () {
            $(window).trigger("resize");
        });
    };

    this.Iniciar();

}
