/* 
 * Creado por Deiner Mena
 * Fecha: 2017-11-05
 */


$.fn.validator.Constructor.DEFAULTS.custom = {
    minlength: function ($el) {
        var minlength = $el.attr('data-minlength');
        return $el.val().length < minlength && "El campo debe tener mínimo " + minlength + " caracteres";
    },

    digits: function ($el) {
        return !(/^[0-9]*$/.test($el.val()))
                && "El campo contiene caracteres no validos";
    },

    'valid-text': function ($el) {
        return !(/^[0-9a-zA-ZÑñáéíóúÁÉÍÓÚ\s()\-_.,"]*$/.test($el.val()))
                && "El campo contiene caracteres no validos";
    },

    'letters': function ($el) {
        return !(/^[a-zA-ZÑñ]*$/.test($el.val()))
                && "El campo contiene caracteres no validos";
    }
}